
// -------------------------------------------------------------- 
// (C)Copyright 2007,                                         
// International Business Machines Corporation, 
// All Rights Reserved.
// Author: Eitan Peri, eitanp@il.ibm.com
// -------------------------------------------------------------- 

#include <stdio.h>
#include <stddef.h>
#include <stdint.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <libspe2.h>
//#include <cbe_mfc.h>
#include <ppu_intrinsics.h>
#include <pthread.h>

//#include <unistd.h>

//#include "common.h"

#define BUFF_SIZE 256 

extern spe_program_handle_t spu;


// Data structures to work with the SPE
//============================================================================
uint64_t ea_ls_base;
uint32_t ls_offset;

uint64_t ea_ls_str;

// Data structure for running SPE thread
//============================================================================
typedef struct spu_data {
  spe_context_ptr_t spe_ctx;
  pthread_t pthread;
  void *argp;
} spu_data_t;

spu_data_t data;

//============================================================================
// Create and run one SPE thread
//============================================================================
void *spu_pthread(void *arg) {

	spu_data_t *datap = (spu_data_t *)arg;
	uint32_t entry = SPE_DEFAULT_ENTRY;
	
	//printf(")PPE: spe thread start run\n" );

	if (spe_context_run(datap->spe_ctx, &entry, 0, datap->argp, NULL, NULL) < 0) {
		perror ("Failed running context");
		exit (1);
	}

	//printf(")PPE: spe thread finish run\n");
	pthread_exit(NULL);
}

int main(int argc, char *argv[])
{
	uint32_t mbx;

	// create SPE context
	if ((data.spe_ctx = spe_context_create (0, NULL)) == NULL) {
		perror("Failed creating context"); exit(1);
	}

	// load SPE program into the SPE context
	if (spe_program_load ( data.spe_ctx, &spu)) {
		perror("Failed loading program"); exit(1);
	}		

	if( (ea_ls_base = (uint64_t)(spe_ls_area_get(data.spe_ctx)))==NULL){
		perror("Failed map LS to main storage"); exit(1);
	}
	
	data.argp = NULL; // don't need it	
			
	if (pthread_create (&data.pthread, NULL, &spu_pthread, &data)) {
		perror("Failed creating thread");  exit(1);
	}   
	
	while(spe_out_mbox_read( data.spe_ctx, &ls_offset, 1)<=0);
	
	//ea_ls_base = ea_ls_base&0xffffffff; // needed for the 32b case
	
	ea_ls_str = ea_ls_base + ls_offset;

	printf("ea_ls_str=0x%llx, ea_ls_base=0x%llx, ls_offset=0x%x\n",ea_ls_str, ea_ls_base, ls_offset);

	// copy a string to the LS
	strcpy( (char*)ea_ls_str, "Ofer Thaler is lemons lemons");
	
	__lwsync(); // make sure that writing to LS is complete before writing the mailbox notification
	
	// notify SPE that the data is ready
	mbx = 1;
	spe_in_mbox_write(data.spe_ctx, &mbx,1,1);
	
	// wait for all the SPE pthread to complete
	if (pthread_join (data.pthread, NULL)) {
		perror("Failed joining thread"); exit (1);
	}

	// destroy the SPE contexts
	if (spe_context_destroy( data.spe_ctx   )) {
		perror("Failed spe_context_destroy"); exit(1);
	}

	printf("PPE: Complete this educating (but useless) example\n" );
	
	return (0);
}

