
// -------------------------------------------------------------- 
// (C)Copyright 2007,                                         
// International Business Machines Corporation, 
// All Rights Reserved.
// Author: Eitan Peri, eitanp@il.ibm.com
// -------------------------------------------------------------- 

//#include <spu_intrinsics.h>
#include <spu_mfcio.h>
//#include <stdint.h>
#include <stdio.h>
//#include "common.h"
//#include <ctype.h>

//#define waittag(tag_id) mfc_write_tag_mask(1<<tag_id);	mfc_read_tag_status_all();

// static parm_context ctx __attribute__ ((aligned (128)));

#define BUFF_SIZE 256 

// Data structures for the get that this SPE will do
volatile char str[BUFF_SIZE] __attribute__ ((aligned(128)));

int main(int speid , uint64_t argp)
{
	uint32_t mbx, tag_id;

	str[0]=0;
	
	// reserve DMA tag ID
	if((tag_id=mfc_tag_reserve())==MFC_TAG_INVALID){
		perror( "ERROR - can't reserve a tag ID\n"); return 1;
	}
	
	// send to PPE the location of the data buffer to which other SPE should write
	spu_write_out_mbox((uint32_t)str); // stalls mailbox is full.	

	//while (spu_stat_in_mbox () < 1);
	
	mbx = spu_read_in_mbox(); // stalls mailbox is full

	printf("SPE: PPE says '%s'\n",str);
	
	if (mbx<1){
		perror( "ERROR - wring mailbox\n" ); return 1;
	}
	
	mfc_tag_release(tag_id); // release tag ID before exiting
	
	return 0;
}
