// -------------------------------------------------------------- 
// (C)Copyright 2007                                         
// International Business Machines Corporation, 
// All Rights Reserved.
// -------------------------------------------------------------- 

#include <stdio.h>
#include <stddef.h>
#include <stdint.h>

#include <stdlib.h>
#include <string.h>
#include <libspe2.h>
#include <cbe_mfc.h>
#include <pthread.h>

typedef struct spu_data {
  spe_context_ptr_t spe_ctx;
  pthread_t pthread;
  void *argp;
} spu_data_t;

spu_data_t data;

#define BUFF_SIZE 16
#define TAG_NUM 5

volatile char data1[BUFF_SIZE+5] __attribute__ ((aligned (16)));

// Create and run one SPE thread
// // =======================================================================================================
void *spu_pthread(void *arg) {

	spu_data_t *datap = (spu_data_t *)arg;
	unsigned int entry = SPE_DEFAULT_ENTRY;

	printf("main: SPE thread start run\n" );

	if (spe_context_run(datap->spe_ctx, &entry, 0, datap->argp, NULL, NULL) < 0) {
		perror ("Failed running context");
		exit (1);
	}

	printf("main: SPE thread finish run\n");
	pthread_exit(NULL);
}

int main(int argc, char *argv[])
{
	spe_program_handle_t *program;

	uint32_t lsa, eah, eal, tag, size, ret, tag_status, i;
   	volatile spe_mfc_command_area_t* mfc_cmd;
  
	if ((data.spe_ctx = spe_context_create (SPE_MAP_PS, NULL)) == NULL) {
		perror ("Failed creating context");
		exit (1);
	}

	// Load SPE program into the SPE context
	if (!(program = spe_image_open("spu/spu"))) {
		perror("Fail opening image"); return -1;
	}

	// Create SPE pthread
	if (pthread_create (&data.pthread, NULL, &spu_pthread, &data)) {
		perror ("Failed creating thread");
	}   	
	
	if ((mfc_cmd = spe_ps_area_get( data.spe_ctx, SPE_MFC_COMMAND_AREA)) == NULL) {
		perror ("Failed mapping MFC command area");
		exit (1);
	}

	printf("mfc_cmd_area=0x%x\n", (uintptr_t)mfc_cmd);
		
	strcpy( data1, "ABCDEFGHIJKLMNO");

	printf("data1=<%s>\n", data1 );

	// Transfer data to LS
	lsa = data1;
	eal = ((uintptr_t)&data1) & 0xfffffff;
	eah = ((unsigned long long)(uintptr_t)&data1)>>32;
	tag = TAG_NUM;
	size= BUFF_SIZE;

	while( (mfc_cmd->MFC_QStatus & 0x0000FFFF) == 0); 

	do{	
		mfc_cmd->MFC_LSA = lsa;
		mfc_cmd->MFC_EAH = eah;
		mfc_cmd->MFC_EAL = eal;
		mfc_cmd->MFC_Size_Tag = (size<<16) | tag;
		mfc_cmd->MFC_ClassID_CMD = MFC_PUT_CMD;

		ret = mfc_cmd->MFC_CMDStatus;

	} while(ret&0x3); //enqueuing until success

	if( spe_mfcio_tag_status_read( data.spe_ctx, 1<<tag, SPE_TAG_ALL, &tag_status) !=0){
		printf("error in GET command");
	}

	printf("data1=<%s>\n", data1 );
	printf("complete PUT with status =0x%x\n", tag_status );

	// Wait for all the SPE threads to complete
	if (pthread_join (data.pthread, NULL)) {
		perror ("Failed joining thread");
		exit (1);
	}

	if (spe_context_destroy( data.spe_ctx   )) {
		perror("Failed spe_context_destroy");
		return(-1);
	}

	return (0);
}

