// -------------------------------------------------------------- 
// (C)Copyright 2007,                                         
// International Business Machines Corporation, 
// All Rights Reserved.
// -------------------------------------------------------------- 

#include <stdio.h>
#include <spu_intrinsics.h>
#include <spu_mfcio.h>
#include "common.h"

#ifdef MFCIO_TRACE
#include <trace_user.h>
#include <trace_defs.h>
#endif //MFCIO_TRACE

// Local store structures and buffers.
volatile parm_context ctx __attribute__ ((aligned (16)));

#ifdef MFCIO_TRACE
volatile trace_payload_t trace_payload __attribute__ ((aligned (16)));
#endif //MFCIO_TRACE

int main(unsigned long long spu_id, unsigned long long parm)
{	
	unsigned int tag_id, idx,dummy=0;	
	tag_id = mfc_tag_reserve();
	
	printf("spe %llx : start main with tag_id=%u\n", spu_id, tag_id);
	
	// Fetch the context
	// =======================================================================================================
	mfc_get((void *)(&ctx), (unsigned int)parm, sizeof(parm_context), tag_id, 0, 0);
	mfc_write_tag_mask(1<<tag_id);
	mfc_read_tag_status_all(); 
	
	// Wait for PPE to release the lock
	// =======================================================================================================
	volatile int mbox;
	
	while (spu_stat_in_mbox () < 1);
	mbox = spu_read_in_mbox();
	
	// Main loop
	// =======================================================================================================
	for (idx=0; idx<10000; idx++){
		dummy++;
	}

	printf("spe %llx: complete main loop\n", spu_id);

	mfc_tag_release(tag_id);

	printf("spe %llx: released MFC tag and exit\n", spu_id);
	return (0);
}
