
// -------------------------------------------------------------- 
// (C)Copyright 2007,                                         
// International Business Machines Corporation, 
// All Rights Reserved.
// Author: Eitan Peri, eitanp@il.ibm.com
// -------------------------------------------------------------- 

#include <stdio.h>
#include <errno.h>
#include <stddef.h>
#include <stdint.h>
#include <ctype.h>
#include <stdlib.h>
#include <libspe2.h>
#include <cbe_mfc.h>
#include <pthread.h>

#include "com_print.h"

#define NUM_EVENTS 1

#define NUM_MBX 30


// Daata structure for running SPE thread
//============================================================================
typedef struct spu_data {
  spe_context_ptr_t spe_ctx;
  pthread_t pthread;
  void *argp;
} spu_data_t;

spu_data_t data;


// Create and run one SPE thread
//============================================================================
void *spu_pthread(void *arg) {

	spu_data_t *datap = (spu_data_t *)arg;
	unsigned int entry = SPE_DEFAULT_ENTRY;
	
	printf(")PPE: spe thread start run\n" );

	if (spe_context_run(datap->spe_ctx, &entry, 0, datap->argp, NULL, NULL) < 0) {
		perror ("Failed running context");
		exit (1);
	}

	printf(")PPE: spe thread finish run\n");
	pthread_exit(NULL);
}



//============================================================================
// Create and run one SPE thread
//============================================================================



int main()
{
	spe_program_handle_t *program;
	//int ret;
	
	int i, ret, num_events, cnt;
	spe_event_handler_ptr_t event_hand;
	spe_event_unit_t event_uni, pend_events[NUM_EVENTS];
	uint32_t mbx=1;
	
	data.argp = NULL;	
	
	// create SPE context
	if ((data.spe_ctx = spe_context_create (SPE_EVENTS_ENABLE, NULL)) == NULL) {
		perror("Failed creating context"); exit(1);
	}
	
	// create a handle event handler 
	event_hand = spe_event_handler_create();

	// register event handler 
	event_uni.events = SPE_EVENT_IN_MBOX;
	event_uni.spe = data.spe_ctx;
	ret = spe_event_handler_register(event_hand, &event_uni);
	
	// more types of events	 may be registered here
	
	// open an image of SPE program into main storage
	if (!(program = spe_image_open("spu/spu"))) {
		perror("Fail opening image"); exit(1);
	}

	// load SPE program into the SPE context
    if (spe_program_load (data.spe_ctx, program)) {
      perror("Failed loading program"); exit(1);
    }

	// create SPE pthread
	if (pthread_create (&data.pthread, NULL, &spu_pthread, &data)) {
		perror("Failed creating thread");  exit(1);
	}   	

	// write 4 first messages to make the mailbox queue full
	for (mbx=1; mbx<5; mbx++){
		prn_p_mbx_m2s(mbx,0,mbx);
		ret = spe_in_mbox_write(data.spe_ctx, &mbx,1,SPE_MBOX_ANY_BLOCKING);
 	}
		
	// loop on all pending events
	for ( ; mbx<NUM_MBX; ) {
		// wait for events to be set
		num_events = spe_event_wait(event_hand, pend_events, NUM_EVENTS, -1);
		
		// few events were set - handle them
		for (i = 0; i < num_events; i++) {
			if (pend_events[i].events & SPE_EVENT_IN_MBOX){
				
				// if SPE read from mailbox - write to mailbox till it is full
				for (cnt = spe_in_mbox_status(pend_events[i].spe); cnt>0; cnt--){
					mbx++;
					prn_p_mbx_m2s(mbx,0,mbx);
					ret = spe_in_mbox_write(pend_events[i].spe, &mbx,1,SPE_MBOX_ANY_BLOCKING);
				}
			}			
			
			// if we register more types of events - we can handle them here
		}
	}
	
	// wait for all the SPE pthread to complete
	if (pthread_join (data.pthread, NULL)) {
		perror("Failed joining thread"); exit (1);
	}

	//Destroy the handle.
	spe_event_handler_destroy(event_hand);
	
	// destroy the SPE contexts
	if (spe_context_destroy( data.spe_ctx   )) {
		perror("Failed spe_context_destroy"); exit(1);
	}

	// wait for SPE data to be written into memory

	printf(")PPE: program was completed successfully\n");
	
	return (0);
}

