
// -------------------------------------------------------------- 
// (C)Copyright 2007,                                         
// International Business Machines Corporation, 
// All Rights Reserved.
// Author: Eitan Peri, eitanp@il.ibm.com
// -------------------------------------------------------------- 

#include <stdio.h>
#include <stddef.h>
#include <stdint.h>
#include <ctype.h>
#include <stdlib.h>
//#include <string.h>
#include <libspe2.h>
#include <cbe_mfc.h>
#include <pthread.h>

#define NUM_OF_BUFF 5

// Data structures to work with the SPE
//============================================================================
#define BUFF_SIZE 1024


uint32_t ls_offset;  // offset from LS base of the data buffer in LS

// PPUs data buffer
volatile char my_data[BUFF_SIZE] __attribute__ ((aligned(128)));

// Daata structure for running SPE thread
//============================================================================
typedef struct spu_data {
  spe_context_ptr_t spe_ctx;
  pthread_t pthread;
  void *argp;
} spu_data_t;

spu_data_t data;


// Create and run one SPE thread
//============================================================================
void *spu_pthread(void *arg) {

	spu_data_t *datap = (spu_data_t *)arg;
	unsigned int entry = SPE_DEFAULT_ENTRY;
	
	printf(")PPE: spe thread start run\n" );

	if (spe_context_run(datap->spe_ctx, &entry, 0, datap->argp, NULL, NULL) < 0) {
		perror ("Failed running context");
		exit (1);
	}

	printf(")PPE: spe thread finish run\n");
	pthread_exit(NULL);
}



//============================================================================
// Create and run one SPE thread
//============================================================================

int main()
{
	spe_program_handle_t *program;
	int ret;
	uint32_t tag, status;

	// MUST use only tag 0-15 since 16-31 are used by kernel	
	tag = 7; // choose my lucky number
	
	data.argp = NULL;	
	
	// create SPE context
	if ((data.spe_ctx = spe_context_create (SPE_MAP_PS, NULL)) == NULL) {
		perror("Failed creating context"); exit(1);
	}

	// open an image of SPE program into main storage
	if (!(program = spe_image_open("spu/spu"))) {
		perror("Fail opening image"); exit(1);
	}

	// load SPE program into the SPE context
    if (spe_program_load (data.spe_ctx, program)) {
      perror("Failed loading program"); exit(1);
    }
	
	// create SPE pthread
	if (pthread_create (&data.pthread, NULL, &spu_pthread, &data)) {
		perror("Failed creating thread");  exit(1);
	}   	
		
	// collect from the SPE the offset in LS of the data buffer. NOT the 
	// most efficient using mailbox- but sufficient for initialization
	while(spe_out_mbox_read( data.spe_ctx, &ls_offset, 1)<=0);

	printf("PPE: ls_offset=0x%x\n", ls_offset );
	
	//intiate DMA put command to transfer data from LS to main storage
	do{
		ret=spe_mfcio_put( data.spe_ctx, ls_offset, (void*)my_data, BUFF_SIZE, tag, 0,0);	
	}while( ret!=0);
				
	printf("PPE: complete put in memory\n" );
	
	// wait for completion of the put command
	ret = spe_mfcio_tag_status_read(data.spe_ctx,0,SPE_TAG_ALL, &status);

	__lwsync();
	
	if(ret!=0){
		perror ("Error status was returned.");
		// status variable may provide more information
		exit (1);
	}

	printf("SPE says: %s\n", my_data);

	
	// wait for all the SPE pthread to complete
	if (pthread_join (data.pthread, NULL)) {
		perror("Failed joining thread"); exit (1);
	}
			
	// destroy the SPE contexts
	if (spe_context_destroy( data.spe_ctx   )) {
		perror("Failed spe_context_destroy"); exit(1);
	}

	// wait for SPE data to be written into memory

	printf(")PPE: program was completed successfully\n");
	
	return (0);
}

