
// -------------------------------------------------------------- 
// (C)Copyright 2007,                                         
// International Business Machines Corporation, 
// All Rights Reserved.
// Author: Eitan Peri, eitanp@il.ibm.com
// -------------------------------------------------------------- 

#include <stdio.h>
#include <stdlib.h>
#include <sys/mman.h>

#include <sys/stat.h>
#include <fcntl.h>

int main(int argc, char *argv[])
{
	void *ptr;
	int fmem; 
	char *mem_file = "/huge/myfile.bin"; 
	
	// open a huge pages file	
	if ( (fmem = open(mem_file, O_CREAT | O_RDWR, 0755)) == -1){
		perror("ERROR: Can't open huge pages file"); exit(1);	
	}
	remove(mem_file); 
	
	// map 32MB huge pages file to main sotrage - get effective address
	ptr = mmap(0, 0x2000000, PROT_READ | PROT_WRITE, MAP_PRIVATE, fmem, 0);

	if(ptr==NULL){
		perror("ERROR: Can't map huge pages"); exit(1);
	}
	
	printf("Map huge pages to 0x%llx\n", (unsigned long long int)ptr);

	// now we can use the 
	return (0);
}

