
// -------------------------------------------------------------- 
// (C)Copyright 2007,                                         
// International Business Machines Corporation, 
// All Rights Reserved.
// Author: Eitan Peri, eitanp@il.ibm.com
// -------------------------------------------------------------- 

#include <stdio.h>
#include <stddef.h>
#include <stdint.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <libspe2.h>
#include <cbe_mfc.h>
#include <pthread.h>

#include <unistd.h>

extern spe_program_handle_t spu;


// Data structures to work with the SPE
//============================================================================
spe_program_handle_t *program[2];


volatile spe_spu_control_area_t* mfc_ctl[2];


// Data structure for running SPE thread
//============================================================================
typedef struct spu_data {
  spe_context_ptr_t spe_ctx;
  pthread_t pthread;
} spu_data_t;

spu_data_t data[2];

//============================================================================
// create and run one SPE thread
//============================================================================
void *spu_pthread(void *arg) {

	spu_data_t *datap = (spu_data_t *)arg;
	uint32_t entry = SPE_DEFAULT_ENTRY;

	if (spe_context_run(datap->spe_ctx, &entry,0,NULL,NULL,NULL)<0){
		perror ("Failed running context");
		exit (1);
	}
	pthread_exit(NULL);
}

//============================================================================
// main
//============================================================================
int main()
{
	int num, ack;
	//uint32_t eah, eal;
	uint64_t ea;
	
	char str[2][8] = {"0 is up","1 is up"};

	printf("S)PPE:) Start with huge hope\n");
	
	// create SPE context and load SPE program into the SPE context
	for( num=0; num<2; num++){
		if ((data[num].spe_ctx = spe_context_create(SPE_MAP_PS,NULL))==NULL){
			perror("Failed creating context"); exit(1);
		}
		if (spe_program_load( data[num].spe_ctx, &spu)) {
			perror("Failed loading program"); exit(1);
		}		
	}
			
	// create SPE pthreads
	for( num=0; num<2; num++){
		if (pthread_create (&data[num].pthread, NULL, &spu_pthread, &data[num])) {
			perror("Failed creating thread");  exit(1);
		}   
	}
	
	// STEP 0: map SPE's MFC problem state to main storage (get effective address)
	for( num=0; num<2; num++){
		if ((mfc_ctl[num] = (spe_spu_control_area_t*)spe_ps_area_get( data[num].spe_ctx, SPE_CONTROL_AREA))==NULL){
			perror ("Failed mapping MFC control area");	exit (1);
		}
	}
	
	// STEP 1: send each SPE its number using BLOCKING mailbox write
	for( num=0; num<2; num++){			
		printf("1)PPE->SPE%d: <%u>\n", num, num);
		
		// write 1 entry to in_mailbox - we don't know if we have availalbe space so use blocking
		spe_in_mbox_write(data[num].spe_ctx, (uint32_t*)&num,1,SPE_MBOX_ALL_BLOCKING);
	}
	
	// STEP 2: send each SPE the effective address of other SPE's MFC area and a string
	//             use NON-BLOCKING mailbox write after first verifying availability of space
	for( num=0; num<2; num++){	
	
		ea = (uint64_t)mfc_ctl[(num==0)?1:0];
		
		// loop till we have 4 entries available
		while(spe_in_mbox_status(data[num].spe_ctx)<4){
		
			// PPE can do other things meanwhile before check status again
		}
		
		printf("2)PPE->SPE%d: <%llx>\n", num, ea);		
		printf("2)PPE->SPE%d: <%s>\n", num, str[num]);
		
		// write 4 entries to in_mailbox - we just checked that we have availalbe space  so use nonblocking
		spe_in_mbox_write(data[num].spe_ctx, (uint32_t*)&ea,2,SPE_MBOX_ANY_NONBLOCKING);		
		spe_in_mbox_write(data[num].spe_ctx, (uint32_t*)&str[num],2,SPE_MBOX_ANY_NONBLOCKING);
	}

	// STEP 3: 	read acknowledge from each SPE using NON-BLOCKING maibox read
	for( num=0; num<2; num++){	
		while(!spe_out_mbox_status(data[num].spe_ctx)){
		
			// PPE can do other things meanwhile before check status again
		};
		spe_out_mbox_read(data[num].spe_ctx, (uint32_t*)&ack, 1);	
		
		printf("3)PPE<-SPE%u: <%d>\n",num,ack);
	}
		
	// wait for both SPE to complete
	for( num=0; num<2; num++){
		// wait for all the SPE pthread to complete
		if (pthread_join (data[num].pthread, NULL)) {
			perror("Failed joining thread"); exit (1);
		}

		// destroy the SPE contexts
		if (spe_context_destroy( data[num].spe_ctx   )) {
			perror("Failed spe_context_destroy"); exit(1);
		}
	}

	printf("E)PPE:) Complete with great success\n");
	
	return (0);
}

