
// -------------------------------------------------------------- 
// (C)Copyright 2007,                                         
// International Business Machines Corporation, 
// All Rights Reserved.
// Author: Eitan Peri, eitanp@il.ibm.com
// -------------------------------------------------------------- 

#include <spu_intrinsics.h>
#include <spu_mfcio.h>
#include <stdint.h>
#include <stdio.h>
#include <ctype.h>

#include "spu_mfcio_ext.h"

uint32_t my_num;

// Macro for waiting to completion of DMA group related to input tag:
// 1. Write tag mask. 2. Read status which is blocked untill all tags DMA are completed
#define waitag(t) mfc_write_tag_mask(1<<t); mfc_read_tag_status_all();


int main( )
{
	uint32_t data[2],ret, mbx;
	uint32_t ea_mfc_h, ea_mfc_l, tag_id;
	uint64_t ea_mfc;

	printf("S<SPE %d: starts\n",my_num);
	
	if ((tag_id= mfc_tag_reserve())==MFC_TAG_INVALID){
		printf("SPE: ERROR can't allocate tag ID\n"); return -1;
	}
	
	// STEP 1: read from PPE my number using BLOCKING mailbox read	
	while( spu_stat_in_mbox()<=0 );
	my_num   = spu_read_in_mbox();
	printf("1}SPE%d<-PPE: <%u>\n",my_num,my_num);

	// STEP 2: receive from PPE the effective address of other SPE's MFC area and a string
	//             use BLOCKING mailbox, but to avoid bloking we first read status to check that we have 4 valid entries
	while( spu_stat_in_mbox()<4 ){
		
		// SPE can do other things meanwhile before check status again
	}
	
	ea_mfc_h = spu_read_in_mbox(); // read EA lower bits 
	ea_mfc_l = spu_read_in_mbox(); // read EA higher bits 

	printf("2}SPE%d<-PPE: <%x>\n",my_num,ea_mfc_h);
	printf("2}SPE%d<-PPE: <%x>\n",my_num,ea_mfc_l);
	
	data[0] = spu_read_in_mbox();// read 4 bytes of string
	data[1] = spu_read_in_mbox();// read 4 more bytes of string
	
	printf("2}SPE%d<-PPE: <%s>\n",my_num,(char*)data);
		
	ea_mfc = mfc_hl2ea( ea_mfc_h, ea_mfc_l);
	
	// STEP 3: 	write my number as acknowledge to PPE using BLOCKING maibox write	
	printf("3}SPE%d->PPE: <%u>\n",my_num,my_num+1313000);
	spu_write_out_mbox(my_num+1313000); //add dummy constant to pad MSb
	
	// STEP 4: 	write some number to the other SPE's mailbox using BLOCKING write
	mbx = my_num + 1212000; //add dummy constant to pad MSb
	printf("4}SPE%d->SPE: <%u>\n",my_num,mbx);

	ret =  write_in_mbox( mbx, ea_mfc, tag_id);
	if (ret!=1){
		printf("SPE %d: fail to send MBOX to other SPE\n",my_num); return -1;
	}

	// STEP 5: 	read mailbox written by other SPE
	data[0] = spu_read_in_mbox();

	printf("5}SPE%d<-SPE: <%u>\n",my_num,data[0] );
	
	printf("E<SPE %d: ended\n",my_num);		
	return 0;
}
