
// -------------------------------------------------------------- 
// (C)Copyright 2007,                                         
// International Business Machines Corporation, 
// All Rights Reserved.
// Author: Eitan Peri, eitanp@il.ibm.com
// -------------------------------------------------------------- 

#ifndef _COM_PRINT_H_
#define _COM_PRINT_H_

// ===========================================================================================
// Printing macros for tracing PPE-SPE and SPE-SPE communication
// paremeters (i,s,m) stands for (some user-defined index for example step # in program execution, # of SPE,message value)
// ===========================================================================================
 
// PPU printing macros prefix 'prn_p_') ========================================================

// mailbox printing macros
#define prn_p_mbx_m2s(i,s,m) printf("%d)PPE>>SPE%02u: <%08x>\n",i,s,m); //me to SPE
#define prn_p_mbx_s2m(i,s,m) printf("%d)PPE<<SPE%02u: <%08x>\n",i,s,m); //SPE to me		

// signals printing macros
#define prn_p_sig_m2s(i,s,m) printf("%d)PPE->SPE%02u: <%08x>\n",i,s,m); //me to SPE	
#define prn_p_sig_s2m(i,s,m) printf("%d)PPE<-SPE%02u: <%08x>\n",i,s,m); //SPE to me				

// SPU printing macros prefix 'prn_s_') ========================================================

// mailbox printing macros
#define prn_s_mbx_m2p(i,s,m) printf("%d{SPE%02u>>PPE: <%08x>\n",i,s,m); //me to PPE
#define prn_s_mbx_p2m(i,s,m) printf("%d{SPE%02u<<PPE: <%08x>\n",i,s,m); //PPE to me	
#define prn_s_mbx_m2s(i,s,m) printf("%d{SPE%02u<-SPE: <%08x>\n",i,s,m); //me tp SPE
#define prn_s_mbx_s2m(i,s,m) printf("%d{SPE%02u->SPE: <%08x>\n",i,s,m); //SPE to me

// signals printing macros
#define prn_s_sig_m2p(i,s,m) printf("%d{SPE%02u->PPE: <%08x>\n",i,s,m); //me to PPE
#define prn_s_sig_p2m(i,s,m) printf("%d{SPE%02u<-PPE: <%08x>\n",i,s,m); //PPE to me
#define prn_s_sig_m2s(i,s,m) printf("%d{SPE%02u->SPE: <%08x>\n",i,s,m); //me tp SPE
#define prn_s_sig_s2m(i,s,m) printf("%d{SPE%02u<-SPE: <%08x>\n",i,s,m); //SPE to me



#endif // _COM_PRINT_H_ 
