
// -------------------------------------------------------------- 
// (C)Copyright 2007,                                         
// International Business Machines Corporation, 
// All Rights Reserved.
// Author: Eitan Peri, eitanp@il.ibm.com
// -------------------------------------------------------------- 

#include <stdio.h>
#include <stddef.h>
#include <stdint.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <libspe2.h>
#include <cbe_mfc.h>
#include <pthread.h>
#include <cbea_map.h>

#include <unistd.h>

#include <com_print.h>

extern spe_program_handle_t spu;


// Data structures to work with the SPE
//============================================================================
//spe_program_handle_t *program[2];

volatile spe_sig_notify_1_area_t *ea_sig1[2]; // EA pointer to SPE's singnal1 MMIO registers
volatile spe_sig_notify_2_area_t *ea_sig2[2]; // EA pointer to SPE's singnal2 MMIO registers


// Data structure for running SPE thread
//============================================================================
typedef struct spu_data {
  spe_context_ptr_t spe_ctx;
  pthread_t pthread;
} spu_data_t;

spu_data_t data[2];

//============================================================================
// create and run one SPE thread
//============================================================================
void *spu_pthread(void *arg) {

	spu_data_t *datap = (spu_data_t *)arg;
	uint32_t entry = SPE_DEFAULT_ENTRY;

	if (spe_context_run(datap->spe_ctx, &entry,0,NULL,NULL,NULL)<0){
		perror ("Failed running context");
		exit (1);
	}
	pthread_exit(NULL);
}

//============================================================================
// main
//============================================================================
int main()
{
	int num, ret[2],mbx[2];
	uint32_t sig=0x80000000; // bit 31 indicates signal from PPE
	uint64_t ea;

	printf("S)PPE:) Start with huge hope\n");
	
	// create SPE context and load SPE program into the SPE context
	for( num=0; num<2; num++){
		if ((data[num].spe_ctx = spe_context_create(SPE_MAP_PS|SPE_CFG_SIGNOTIFY1_OR,NULL))==NULL){
			perror("Failed creating context"); exit(1);
		}
		if (spe_program_load( data[num].spe_ctx, &spu)) {
			perror("Failed loading program"); exit(1);
		}		
	}
	for( num=0; num<2; num++){
		if (pthread_create (&data[num].pthread, NULL, &spu_pthread, &data[num])) {
			perror("Failed creating thread");  exit(1);
		}   
	}
	
	// STEP 0: map SPE's signals area to main storage (get effective address)
	for( num=0; num<2; num++){
		if ((ea_sig1[num] = (spe_sig_notify_1_area_t*)spe_ps_area_get( data[num].spe_ctx, SPE_SIG_NOTIFY_1_AREA))==NULL){
			perror ("Failed mapping Signal1 area");	exit (1);
		}
		if ((ea_sig2[num] = (spe_sig_notify_2_area_t*)spe_ps_area_get( data[num].spe_ctx, SPE_SIG_NOTIFY_2_AREA))==NULL){
			perror ("Failed mapping Signal2 area");	exit (1);
		}
	}
	
	// STEP 1: send each SPE the EA of the other SPE's signals area
	for( num=0; num<2; num++){
		// first time writing to this SPE so we know mailbox has 4 entries empty
		spe_in_mbox_write(data[num].spe_ctx, (uint32_t*)&num,1,SPE_MBOX_ANY_NONBLOCKING);
		ea = (uint64_t)ea_sig1[(num==0)?1:0];
		spe_in_mbox_write(data[num].spe_ctx, (uint32_t*)&ea,2,SPE_MBOX_ANY_NONBLOCKING);

		// wait we have 2 entries free
		while(spe_in_mbox_status(data[num].spe_ctx)<2);
		
		// send the last 2 entries - we checked that we have available space
		ea = (uint64_t)ea_sig2[(num==0)?1:0];
		spe_in_mbox_write(data[num].spe_ctx, (uint32_t*)&ea,2,SPE_MBOX_ANY_NONBLOCKING);
	}
	
	// STEP 2: wait for SPEs to start signaling loop
	for( num=0; num<2; num++){
		while(!spe_out_mbox_status(data[num].spe_ctx));
		spe_out_mbox_read(data[num].spe_ctx, (uint32_t*)&mbx[num], 1);	
		prn_p_mbx_s2m(4,1,sig);
	};
	
	// STEP 3: wait for  while - let SPEs signal one to another
	for( num=0; num<20000000; num++){
		mbx[0] = mbx[0] *2;
	}
	
	// STEP 4: send the SPEs a signal to stop		
	prn_p_sig_m2s(4,0,sig);
	prn_p_sig_m2s(4,1,sig);
	ret[0] = spe_signal_write(data[0].spe_ctx, SPE_SIG_NOTIFY_REG_1,sig);
	ret[1] = spe_signal_write(data[1].spe_ctx, SPE_SIG_NOTIFY_REG_2,sig);
	
	if (ret[0]==-1 || ret[1]==-1){
		perror ("Failed writing signal to SPEs"); exit (1);
	}
		
	// STEP 5: wait till SPEs tell me that they're done
	for( num=0; num<2; num++){
		while(!spe_out_mbox_status(data[num].spe_ctx));
	
		spe_out_mbox_read(data[num].spe_ctx, (uint32_t*)&mbx[num], 1);	
		prn_p_mbx_s2m(5,num,mbx[num]);
	};
	
	// STEP 6: tell SPEs that they can omplete execution
	for( num=0; num<2; num++){
		mbx[num] = ~mbx[num];
		spe_in_mbox_write(data[num].spe_ctx, (uint32_t*)&mbx[num],2,SPE_MBOX_ANY_NONBLOCKING);
		prn_p_mbx_m2s(6,num,mbx[num]);
		
	}
	
	// STEP 7: wait for both SPEs to complete
	for( num=0; num<2; num++){
		if (pthread_join (data[num].pthread, NULL)) {
			perror("Failed joining thread"); exit (1);
		}
		if (spe_context_destroy( data[num].spe_ctx   )) {
			perror("Failed spe_context_destroy"); exit(1);
		}
	}

	printf("E)PPE:) Complete with great success\n");
	
	return (0);
}

