
// -------------------------------------------------------------- 
// (C)Copyright 2007,                                         
// International Business Machines Corporation, 
// All Rights Reserved.
// Author: Eitan Peri, eitanp@il.ibm.com
// -------------------------------------------------------------- 

#include <spu_intrinsics.h>
#include <spu_mfcio.h>
#include <stdint.h>
#include <stdio.h>
#include <ctype.h>

#include "spu_mfcio_ext.h"

#include <com_print.h>

#define NUM_ITER 1000

uint32_t num;

// Macro for waiting to completion of DMA group related to input tag:
// 1. Write tag mask. 2. Read status which is blocked untill all tags DMA are completed
#define waitag(t) mfc_write_tag_mask(1<<t); mfc_read_tag_status_all();

int main( )
{
	uint32_t in_sig,out_sig,mbx,idx,i,ea_h,ea_l,tag_id;
	uint64_t ea_sig[2];

	printf("S<SPE %d: starts\n",num);
	
	if ((tag_id= mfc_tag_reserve())==MFC_TAG_INVALID){
		printf("SPE: ERROR can't allocate tag ID\n"); return -1;
	}
	
	// STEP 1: read from PPE my number using BLOCKING mailbox read	
	num  = spu_read_in_mbox();
	idx     = (num==0)?1:0;
	out_sig = (1<<num);

	// STEP 2: receive from PPE the effective address of other SPE's signals area and a string
	while( spu_stat_in_mbox()<4 );
	for (i=0;i<2;i++){
		ea_h = spu_read_in_mbox(); // read EA lower bits 
		ea_l = spu_read_in_mbox(); // read EA higher bits 
		ea_sig[i] = mfc_hl2ea( ea_h, ea_l);
	}
			
	// STEP 3: Tell the PPE that we are going to start loopoing
	mbx = 0x44332211;
	prn_s_mbx_m2p(3,num,mbx);

	spu_write_out_mbox( mbx );

	// STEP 4: Start looping-  signal other SPE and read my signal notification
	if (num==0){
		write_signal2( out_sig, ea_sig[idx], tag_id);
		while(1){
			in_sig = spu_read_signal1();

			if (in_sig&0x80000000){ break; }
			
			if (in_sig&0x00000002){
				prn_s_sig_m2s(4,num,out_sig);
				write_signal2( out_sig, ea_sig[idx], tag_id);
			}else{
				printf("}}SPE%d<<NA:   <%08x>\n",num,in_sig);
				return -1;
			}
		}
	}else{ //num==1
		while(1){
			in_sig = spu_read_signal2();
			
			if (in_sig&0x80000000){ break; }
			
			if (in_sig&0x00000001){
				prn_s_sig_m2s(4,num,out_sig);
				write_signal1( out_sig, ea_sig[idx], tag_id);
			}else{
				printf("}}SPE%d<<NA:   <%08x>\n",num,in_sig);
				return -1;
			}
		}
	}
	prn_s_sig_p2m(4,num,in_sig);
	
	// STEP 5: tell tell the PPE that we're done
	mbx = 0x11223344*(num+1);
	prn_s_mbx_m2p(5,num,mbx);
	spu_write_out_mbox( mbx );

	// STEP 6: block on last mailbox from PPE - so we will not finish before other SPE
	mbx = spu_read_in_mbox();
	prn_s_mbx_p2m(5,num,mbx);
	
	mfc_tag_release(tag_id);
	
	printf("E<SPE %d: ended\n",num);		
	return 0;
}
