// ==================================================================
// ppu_main.c file
// ==================================================================

#include <stdio.h>
#include <stddef.h>
#include <stdint.h>
#include <ctype.h>
#include <stdlib.h>
#include <libspe2.h>
//#include <pthread.h>

#include "common.h"


spe_program_handle_t spu_main; // a pointer to SPE object
spe_context_ptr_t spe_ctx;     // SPE context

// data structures to work with the SPE
//====================================================================

volatile parm_context ctx __attribute__ ((aligned(16)));

volatile char in_data[BUFF_SIZE]  __attribute__ ((aligned(128)));
volatile char out_data[BUFF_SIZE] __attribute__ ((aligned(128)));


void print_stop_reason( spe_stop_info_t *stop_info ){

	// result is a union that holds the SPE output result
	int result=stop_info->result.spe_exit_code; 
	
    switch (stop_info->stop_reason) {
    case SPE_EXIT:
        printf(")PPE: SPE stop_reason=SPE_EXIT, exit_code=");
        break;
    case SPE_STOP_AND_SIGNAL:
        printf(")PPE: SPE stop_reason=SPE_STOP_AND_SIGNAL, signal_code=");
        break;
    case SPE_RUNTIME_ERROR:
        printf(")PPE: SPE stop_reason=SPE_RUNTIME_ERROR, runtime_error=");
        break;
    case SPE_RUNTIME_EXCEPTION:
        printf(")PPE: SPE stop_reason=SPE_RUNTIME_EXCEPTION, runtime_exception=");
        break;
    case SPE_RUNTIME_FATAL:
        printf(")PPE: SPE stop_reason=SPE_RUNTIME_FATAL, runtime_fatal=");
        break;
    case SPE_CALLBACK_ERROR:
        printf(")PPE: SPE stop_reason=SPE_CALLBACK_ERROR callback_error=");
        break;
    default:
        printf(")PPE: SPE stop_reason=UNKNOWN, result=\n");
        break;
    }
    printf("%d, status=%d\n",result,stop_info->spu_status);
}
// main
//====================================================================
int main( )
{
    spe_stop_info_t stop_info;
	uint32_t entry = SPE_DEFAULT_ENTRY;
		
	// STEP 1: initiate SPE control structure
	ctx.ea_in    = (uint64_t)in_data;
	ctx.ea_out   = (uint64_t)out_data;
	
	printf(")PPE: ea_in=0x%llx, ea_out=0x%llx\n",ctx.ea_in,ctx.ea_out );

	// STEP 2: create SPE context
	if ((spe_ctx = spe_context_create (0, NULL)) == NULL){
		perror("Failed creating context"); exit(1);
	}

	// STEP 3: Load SPE object into SPE context local store
	if (spe_program_load(spe_ctx, &spu_main)) {
		perror("Failed loading program"); exit(1);
	}
	
  // STEP 4: Run the SPE context (see spu_pthread function above
  //         Note: this a synchronous call to the operating system 
  //               which blocks until the SPE stops executing and the 
  //               operating system returns from the system call that 
  //               invoked the SPE execution.
  
  if(spe_context_run(spe_ctx,&entry,0,(void*)&ctx,NULL, &stop_info )<0){
		perror ("Failed running context"); 		exit (1);
	}

	print_stop_reason( &stop_info );
	
	// STEP 5: destroy the SPE context
	if (spe_context_destroy( spe_ctx   )) {
		perror("Failed spe_context_destroy"); exit(1);
	}

	printf(")PPE: program was completed successfully\n");
	
	return (0);
}
