// ==================================================================
// spu_main.c file
// ==================================================================
#include <spu_intrinsics.h>
#include <spu_mfcio.h>
#include <stdint.h>
#include <stdio.h>
#include "common.h"
#include <ctype.h>

static parm_context ctx __attribute__ ((aligned (128)));

volatile char in_data[BUFF_SIZE]  __attribute__ ((aligned(128)));
volatile char out_data[BUFF_SIZE] __attribute__ ((aligned(128)));

int main(int speid , uint64_t argp)
{
	uint32_t tag_id;

	//STEP 1: reserve tag IDs
	if((tag_id=mfc_tag_reserve())==MFC_TAG_INVALID){ // allocate tag
		printf("SPE: ERROR - can't reserve a tag ID\n"); return 1;
	}

	//STEP 2: get context information from system memory.
	mfc_get((void*) &ctx, argp, sizeof(ctx), tag_id, 0, 0);
	mfc_write_tag_mask(1<<tag_id);
	mfc_read_tag_status_all();
	
	printf("<SPE: ea_in=0x%llx, ea_out=0x%llx\n",ctx.ea_in,ctx.ea_out );
		
	//STEP 3: get input buffer, process it, and put results in output buffer

	//STEP 4: release tag IDs
	mfc_tag_release(tag_id); // release tag ID before exiting

	return 0;
}
