// spu_main2.c file ==================================================
#include <spu_intrinsics.h>
#include <spu_mfcio.h>
#include <stdint.h>
#include <stdio.h>
#include <ctype.h>

#include "common.h"

static parm_context ctx __attribute__ ((aligned (128)));

volatile char in_data[BUFF_SIZE]  __attribute__ ((aligned(128)));
volatile char out_data[BUFF_SIZE] __attribute__ ((aligned(128)));

int main(int speid , uint64_t argp)
{
	uint32_t tag_id;

	if((tag_id=mfc_tag_reserve())==MFC_TAG_INVALID){ // allocate tag
		printf("SPE: ERROR - can't reserve a tag ID\n"); return 1;
	}

	// get context information from system memory.
	mfc_get((void*) &ctx, argp, sizeof(ctx), tag_id, 0, 0);
	mfc_write_tag_mask(1<<tag_id);
	mfc_read_tag_status_all();
	
	printf("<SPE: Addie Dvir would like to fly here.\n" );

	// get input, process it using method B, and put results in output

	mfc_tag_release(tag_id); // release tag ID before exiting
	return 0;
}
