// -------------------------------------------------------------- 
// (C)Copyright 2007,                                         
// International Business Machines Corporation, 
// All Rights Reserved.
// -------------------------------------------------------------- 

#ifndef _COMMON_H_
#define _COMMON_H_

#define STATUS_DONE      1234567
#define STATUS_NO_DONE ~(STATUS_DONE)

#define MIN(a,b) (((a)>(b)) ? (b) : (a))
#define MAX(a,b) (((a)>(b)) ? (a) : (b))

#define MAX_LIST_SIZE 2048  // 2K

// DEBUG VALUES
/*
#define DMA_LIST_LEN  16
#define ELEM_PER_DMA   4
#define NOTIFY_INCR    4
#define DATA_LEN      15

#define DMA_LIST_LEN  256
#define ELEM_PER_DMA   16
#define NOTIFY_INCR    16
#define DATA_LEN    15
*/

#define DMA_LIST_LEN  512
#define ELEM_PER_DMA   16
#define NOTIFY_INCR    16
#define DATA_LEN    15

#define TOTA_NUM_ELEM ELEM_PER_DMA*DMA_LIST_LEN
#define BUFF_SIZE   TOTA_NUM_ELEM+128 // 128KB of LS

#define CMD_EMPTY	0
#define CMD_GO      1
#define CMD_STOP	2
#define CMD_DONE	3

// data elements that SPE should work on 
typedef struct {
	char cmd;
	char data[DATA_LEN];	
} data_elem; // aligned to 128B

// the context that PPE forward to SPE
typedef struct{
    uint64_t ea_in;
    uint64_t ea_out;
    uint32_t elem_per_dma;
    uint32_t tot_num_elem;
	uint64_t status;
} parm_context; // aligned to 16B 


inline char calc_out_d( char in_d ){
	return in_d-1;
}

// ============================================================================
// FROM Utils
// ============================================================================


#endif // _COMMON_H_ 
