// -------------------------------------------------------------- 
// (C)Copyright 2007                                         
// International Business Machines Corporation, 
// All Rights Reserved.
// -------------------------------------------------------------- 

#include <stdio.h>
#include <stddef.h>
#include <stdint.h>
#include <ctype.h>
#include <stdlib.h>
//#include <string.h>
#include <libspe2.h>
#include <cbe_mfc.h>
#include <pthread.h>

#include "common.h"

// Data structures to work with the SPE
//============================================================================
volatile parm_context ctx __attribute__ ((aligned(16)));
volatile data_elem in_data[TOTA_NUM_ELEM] __attribute__ ((aligned(128)));
volatile data_elem out_data[TOTA_NUM_ELEM] __attribute__ ((aligned(128)));
volatile uint32_t status __attribute__ ((aligned(128)));


// Daata structure for running SPE thread
//============================================================================
typedef struct spu_data {
  spe_context_ptr_t spe_ctx;
  pthread_t pthread;
  void *argp;
} spu_data_t;

spu_data_t data;

//============================================================================
// Create and run one SPE thread
//============================================================================
void *spu_pthread(void *arg) {

	spu_data_t *datap = (spu_data_t *)arg;
	unsigned int entry = SPE_DEFAULT_ENTRY;
	
	printf(")PPE: spe thread start run\n" );

	if (spe_context_run(datap->spe_ctx, &entry, 0, datap->argp, NULL, NULL) < 0) {
		perror ("Failed running context");
		exit (1);
	}

	printf(")PPE: spe thread finish run\n");
	pthread_exit(NULL);
}

int main(int argc, char *argv[])
{
	spe_program_handle_t *program;
	int i, j, error=0;

	status = STATUS_NO_DONE;
	
	for (i=0; i<TOTA_NUM_ELEM; i++){
		in_data[i].cmd  = CMD_GO;
		out_data[i].cmd = CMD_EMPTY;
		
		for (j=0; j<DATA_LEN; j++){
			in_data[i].data[j]  = (char)j;
			out_data[i].data[j] = 0;
		}
	}
	
	//in_data[3+10*ELEM_PER_DMA*NOTIFY_INCR].cmd  = CMD_STOP;
	
	// init SPE parameters
    ctx.ea_in    = (uint64_t)in_data;
    ctx.ea_out   = (uint64_t)out_data;
    ctx.elem_per_dma = ELEM_PER_DMA;
    ctx.tot_num_elem = TOTA_NUM_ELEM;
    ctx.status   = (uint64_t)&status;
		
	data.argp = (void*)&ctx;	
	
	// create SPE context
	if ((data.spe_ctx = spe_context_create (0, NULL)) == NULL) {
		perror("Failed creating context"); exit(1);
	}

	// open an image of SPE program into main storage
	if (!(program = spe_image_open("spu/spu"))) {
		perror("Fail opening image"); exit(1);
	}

	// load SPE program into the SPE context
    if (spe_program_load (data.spe_ctx, program)) {
      perror("Failed loading program"); exit(1);
    }
	
	// create SPE pthread
	if (pthread_create (&data.pthread, NULL, &spu_pthread, &data)) {
		perror("Failed creating thread");  exit(1);
	}   	
	
	// wait for all the SPE pthread to complete
	if (pthread_join (data.pthread, NULL)) {
		perror("Failed joining thread"); exit (1);
	}

	// destroy the SPE contexts
	if (spe_context_destroy( data.spe_ctx   )) {
		perror("Failed spe_context_destroy"); exit(1);
	}

	// wait for SPE data to be written into memory
	printf(")PPE: Wait for output data to be written to memory\n");
	while (status != STATUS_DONE);

	/*
	printf(")))))))))))))))))))))))))))))))))\n");
	for (i=0; i<TOTA_NUM_ELEM; i++){
		printf("(%d:",i);
		for (j=0; j<DATA_LEN; j++){
		printf(" %d-%d", in_data[i].data[j], out_data[i].data[j]);
		}
		printf(")\n");
	}
	printf(")))))))))))))))))))))))))))))))))\n");
	*/
	
	for (i=0, error=0; i<TOTA_NUM_ELEM; i++){

		if (out_data[i].cmd != CMD_DONE){
			printf("ERROR: command is not done : index %d of %d\n",i,TOTA_NUM_ELEM);
			error=1;	break;
		}
		
		for (j=0; j<DATA_LEN; j++){
			if ( calc_out_d(in_data[i].data[j]) != out_data[i].data[j]){
				printf("ERROR: wrong output : entry %d char %d\n",i,j);
				printf("    in =%d, out=%d\n",in_data[i].data[j],out_data[i].data[j]);
				printf("    exp=%d, act=%d\n",calc_out_d(in_data[i].data[j]),out_data[i].data[j]);
				error=1;	break;
			}		
		}
		if (error) break;
	}

	if(error){
		printf(")PPE: program was completed with error\n");
	}else{
		printf(")PPE: program was completed successfully\n");
	}
	
	return (0);
}

