// -------------------------------------------------------------- 
// (C)Copyright 2007                                         
// International Business Machines Corporation, 
// All Rights Reserved.
// -------------------------------------------------------------- 

#include <stdio.h>
#include <stddef.h>
#include <stdint.h>

#include <stdlib.h>
//#include <string.h>
#include <libspe2.h>
#include <cbe_mfc.h>
#include <pthread.h>

#include "common.h"


typedef struct spu_data {
  spe_context_ptr_t spe_ctx;
  pthread_t pthread;
  void *argp;
} spu_data_t;

spu_data_t data;

volatile parm_context ctx __attribute__ ((aligned(16)));
volatile uint32_t in_data[NUMBER_OF_ELEMENTS] __attribute__ ((aligned(128)));
volatile uint32_t out_data[NUMBER_OF_ELEMENTS] __attribute__ ((aligned(128)));

volatile uint32_t status __attribute__ ((aligned(128)));

// Create and run one SPE thread
// // =======================================================================================================
void *spu_pthread(void *arg) {

	spu_data_t *datap = (spu_data_t *)arg;
	unsigned int entry = SPE_DEFAULT_ENTRY;
	
	printf(")PPE: spe thread start run\n" );

	if (spe_context_run(datap->spe_ctx, &entry, 0, datap->argp, NULL, NULL) < 0) {
		perror ("Failed running context");
		exit (1);
	}

	printf(")PPE: spe thread finish run\n");
	pthread_exit(NULL);
}

int main(int argc, char *argv[])
{
	spe_program_handle_t *program;
	int i, error;
;

	status = STATUS_NO_DONE;
	
	for (i=0; i<NUMBER_OF_ELEMENTS; i++){
		in_data[i] = i;
		out_data[i] = 0;
	}
	
	ctx.in_data  = in_data; 
	ctx.out_data = out_data;
	ctx.size     = NUMBER_OF_ELEMENTS;
	ctx.status   = &status;
	
	data.argp = &ctx;	
	
	if ((data.spe_ctx = spe_context_create (0, NULL)) == NULL) {
		perror ("Failed creating context");
		exit (1);
	}

	// Load SPE program into the SPE context
	if (!(program = spe_image_open("spu/spu"))) {
		perror("Fail opening image"); return -1;
	}

    if (spe_program_load (data.spe_ctx, program)) {
      perror ("Failed loading program");
      exit (1);
    }
	
	// Create SPE pthread
	if (pthread_create (&data.pthread, NULL, &spu_pthread, &data)) {
		perror ("Failed creating thread");
	}   	
	
	// Wait for all the SPE threads to complete
	if (pthread_join (data.pthread, NULL)) {
		perror ("Failed joining thread");
		exit (1);
	}

	if (spe_context_destroy( data.spe_ctx   )) {
		perror("Failed spe_context_destroy");
		return(-1);
	}

	// Wait for SPE data to be written into memory
	printf(")PPE: Wait for output data to be written to memory\n");
	while (status != STATUS_DONE);
	
	for (i=0, error=0; i<NUMBER_OF_ELEMENTS; i++){
			//printf(">      expected=0x%x, actual=0x%x\n",(~in_data[i]), out_data[i]);
			//printf("       expected=  %u, actual=  %u\n",in_data[i], out_data[i]);
		if (in_data[i] != (~out_data[i])){
			printf("ERROR: different output then expected: index %d of %d\n",i,NUMBER_OF_ELEMENTS);
			printf("       expected=0x%x, actual=0x%x\n",(~in_data[i]), out_data[i]);
			error=1;
			break;
		}		
	}

	if(error){
		printf(")PPE: program was completed with error\n");
	}else{
		printf(")PPE: program was completed successfully\n");
	}
	
	return (0);
}

