// -------------------------------------------------------------- 
// (C)Copyright 2007                                         
// International Business Machines Corporation, 
// All Rights Reserved.
// -------------------------------------------------------------- 

#include <stdio.h>
//#include <stddef.h>
#include <stdint.h>

#include <stdlib.h>
#include <string.h>
#include <libspe2.h>
//#include <pthread.h>

//#include "common.h"

#define spu_mfc_ceil128(value)  ((value + 127) & ~127)
#define spu_mfc_ceil16(value)   ((value +  15) &  ~15)

volatile char str[512]  __attribute__ ((aligned(16)));

int main(int argc, char *argv[])
{

	void *spe_argp, *spe_envp;
	spe_context_ptr_t spe_ctx;
	spe_program_handle_t *program;
	uint32_t entry = SPE_DEFAULT_ENTRY;

	strcpy( str, "I am here but I want to go there!");

	printf("PPE: %s\n", str);

	if ((spe_ctx = spe_context_create (0, NULL)) == NULL) {
		perror ("Failed creating context"); exit (1);
	}

	// Load SPE program into the SPE context
	if (!(program = spe_image_open("spu/spu"))) {
		perror("Fail opening image"); return -1;
	}

    if (spe_program_load(spe_ctx, program)) {
		perror ("Failed loading program");	exit (1);
    }
	
	spe_argp = (void*)str;
	spe_envp = (void*)strlen(str);
	spe_envp = (void*)spu_mfc_ceil16( (uint32_t)spe_envp); //round up to 128 alignment
	
	if (spe_context_run(spe_ctx, &entry, 0, spe_argp, spe_envp, NULL) < 0) {
		perror ("Failed running context");	exit (1);
	}
	
	if (spe_context_destroy( spe_ctx   )) {
		perror("Failed spe_context_destroy");	exit (1);
	}

	printf("PPE: %s\n", str); // is he already there?
		
	return (0);
}

