// -------------------------------------------------------------- 
// (C)Copyright 2007,                                         
// International Business Machines Corporation, 
// All Rights Reserved.
// -------------------------------------------------------------- 

#include <stdio.h>
//#include <ctype.h>
#include <string.h>
//#include <spu_intrinsics.h>
#include <spu_mfcio.h>

// macro for waiting to completion of DMA group related to input tag.
// does so by first setting tag mask and then read the status which is // blocked untill will all tags DMA are completed.
#define waitag(t) mfc_write_tag_mask(1<<t); mfc_read_tag_status_all();

// Local store structures and buffers.
volatile char str[512]  __attribute__ ((aligned(16)));

// argp - effective address pointer to the string in main memory
// envp - size of string in main memory in bytes
int main( uint64_t spuid , uint64_t argp, uint64_t envp )
{
	uint32_t tag_id = mfc_tag_reserve();
	
	if (tag_id==MFC_TAG_INVALID){
		printf("SPE: ERROR can't allocate tag ID\n");
		return -1;
	}

	//printf("SPE: argp=%llx, envp=%llx\n", argp, envp );
	
	// Input parameter argv is a pointer to the SPE context - fetch the parameter context, waiting for it to complete.
	mfc_get((void *)(str), argp, (uint32_t)envp, tag_id, 0, 0);
	waitag(tag_id);

	printf("SPE: %s\n", str);
	strcpy(str, "Am I there? No! I'm still here! I will go there again....");
	
	// Input parameter argv is a pointer to the SPE context - fetch the parameter context, waiting for it to complete.
	mfc_put((void *)(str), argp, (uint32_t)envp, tag_id, 0, 0);
	waitag(tag_id);
	
	mfc_tag_release(tag_id);
  
	return (0);

}
