
#include <spu_intrinsics.h>
#include <stdio.h>

#define NN 20

typedef struct{
	float x;
	float y;
	float z;
	float w;
} vertices;

typedef struct{
	vec_float4 x[NN];
	vec_float4 y[NN];
	vec_float4 z[NN];
	vec_float4 w[NN];
} vvertices;

int main( )
{
	int i, Nv;
	
	vertices  vers[NN*4];
	vvertices vvers __attribute__((aligned (16)));
	
	Nv = NN>>2; //divide by 4;
		
	for (i=0; i<NN; i++){
		vers[i].x = i; 
		vers[i].y = i*100; 
		vers[i].z = i*10000; 
	}

	for (i=0; i<Nv; i++){
		vvers.x[i] = spu_insert( (float)(i*4+0),vvers.x[i],0);
		vvers.x[i] = spu_insert( (float)(i*4+1),vvers.x[i],1);
		vvers.x[i] = spu_insert( (float)(i*4+2),vvers.x[i],2);
		vvers.x[i] = spu_insert( (float)(i*4+3),vvers.x[i],3);
		
		vvers.y[i] = spu_insert( (float)((i*4+0)*100),vvers.y[i],0);
		vvers.y[i] = spu_insert( (float)((i*4+1)*100),vvers.y[i],1);
		vvers.y[i] = spu_insert( (float)((i*4+2)*100),vvers.y[i],2);
		vvers.y[i] = spu_insert( (float)((i*4+3)*100),vvers.y[i],3);
		
		vvers.z[i] = spu_insert( (float)((i*4+0)*10000),vvers.z[i],0);
		vvers.z[i] = spu_insert( (float)((i*4+1)*10000),vvers.z[i],1);
		vvers.z[i] = spu_insert( (float)((i*4+2)*10000),vvers.z[i],2);
		vvers.z[i] = spu_insert( (float)((i*4+3)*10000),vvers.z[i],3);
	}
	
	for (i=0; i<NN; i++){
		vers[i].w = vers[i].x + vers[i].y;
		vers[i].w = vers[i].w + vers[i].z;
	}
	
	for (i=0; i<Nv; i++){
		vvers.w[i] = vvers.x[i] + vvers.y[i];
		vvers.w[i] = vvers.w[i] + vvers.z[i];
	}
	
	printf("scalar ------------------------------------\n");
	for (i=0; i<NN; i++){
		printf("(%02d)[x,y,z,w]=[%f,%f,%f,%f]\n",i,vers[i].x,vers[i].y,vers[i].z,vers[i].w);
	}
	
	printf("vecttor ------------------------------------\n");
	for (i=0; i<Nv; i++){
		printf("(%02d)[x,y,z,w]=[%f,%f,%f,%f]\n",i*4+0,spu_extract(vvers.x[i],0),spu_extract(vvers.y[i],0),spu_extract(vvers.z[i],0),spu_extract(vvers.w[i],0));
		printf("(%02d)[x,y,z,w]=[%f,%f,%f,%f]\n",i*4+1,spu_extract(vvers.x[i],1),spu_extract(vvers.y[i],1),spu_extract(vvers.z[i],1),spu_extract(vvers.w[i],1));
		printf("(%02d)[x,y,z,w]=[%f,%f,%f,%f]\n",i*4+2,spu_extract(vvers.x[i],2),spu_extract(vvers.y[i],2),spu_extract(vvers.z[i],2),spu_extract(vvers.w[i],2));
		printf("(%02d)[x,y,z,w]=[%f,%f,%f,%f]\n",i*4+3,spu_extract(vvers.x[i],3),spu_extract(vvers.y[i],3),spu_extract(vvers.z[i],3),spu_extract(vvers.w[i],3));
	}

	return 0;
}


