

#include <spu_intrinsics.h>
#include <stdio.h>


int main( )
{

	float a=10,b=20,c=30,d=40;
	vector float abcd;
	vector float efgh = {7.0,7.0,7.0,7.0};

	// initiate abcd vector with the values of the scalars
	abcd = spu_insert(a, abcd, 0);
	abcd = spu_insert(b, abcd, 1);
	abcd = spu_insert(c, abcd, 2);
	abcd = spu_insert(d, abcd, 3);

	// SIMD multiply the two vectors
	abcd = spu_mul(abcd, efgh);

	// do many other different SIMD operations on abcd and efgh vectors

	// extract back the scalar from the computed vector
	a = spu_extract(abcd, 0);
	b = spu_extract(abcd, 1);
	c = spu_extract(abcd, 2);
	d = spu_extract(abcd, 3);

	printf("a=%f, b=%f, c=%f, d=%f\n",a,b,c,d); 

	return 0;

}