
// -------------------------------------------------------------- 
// (C)Copyright 2007,                                         
// International Business Machines Corporation, 
// All Rights Reserved.
// Author: Eitan Peri, eitanp@il.ibm.com
// -------------------------------------------------------------- 

#include <spu_intrinsics.h>
#include <stdio.h>

#include "vec_u.h"



int main( )
{
	vec128 a __attribute__((aligned (16)));
	vec128 b __attribute__((aligned (16)));
	
	// do some SIMD operations on a and b vectors

	// perform some operations between scalar of specific vector
	a.f_s[0] = 10;
	a.f_s[1] = a.f_s[0] + 10;
	a.f_s[2] = a.f_s[1] + 10;
	a.f_s[3] = a.f_s[2] + 10;

	// initiate all b elements to be 7
	b.f_v = spu_splats( (float)7.0 );

	// SIMD multiply the two vectors
	a.f_v = spu_mul(a.f_v, b.f_v);

	// do many other different SIMD operations on a and b vectors

	// extract back the scalar from the computed vector

	printf("a0=%f, a1=%f, a2=%f, a3=%f\n",a.f_s[0],a.f_s[1],a.f_s[2],a.f_s[3]); 

	return 0;
}


