
// -------------------------------------------------------------- 
// (C)Copyright 2007,                                         
// International Business Machines Corporation, 
// All Rights Reserved.
// Author: Eitan Peri, eitanp@il.ibm.com
// -------------------------------------------------------------- 

#include <stdio.h>
#include <stddef.h>
#include <stdint.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <libspe2.h>
#include <cbe_mfc.h>
#include <pthread.h>

#include <unistd.h>

extern spe_program_handle_t spu;


// Data structures to work with the SPE
//============================================================================
spe_program_handle_t *program[2];



int a_b[2] __attribute__ ((aligned (16)));


// Data structure for running SPE thread
//============================================================================
typedef struct spu_data {
  spe_context_ptr_t spe_ctx;
  pthread_t pthread;
  void *argp;

} spu_data_t;

spu_data_t data;

//============================================================================
// create and run one SPE thread
//============================================================================
void *spu_pthread(void *arg) {

	spu_data_t *datap = (spu_data_t *)arg;
	uint32_t entry = SPE_DEFAULT_ENTRY;

	if (spe_context_run(datap->spe_ctx, &entry,0,datap->argp,NULL,NULL)<0){
		perror ("Failed running context");
		exit (1);
	}
	pthread_exit(NULL);
}

//============================================================================
// main
//============================================================================
int main()
{

	printf("PPE: Start with huge hope\n");
	
	// create SPE context and load SPE program into the SPE context
	if ((data.spe_ctx = spe_context_create(SPE_MAP_PS,NULL))==NULL){
		perror("Failed creating context"); exit(1);
	}
	if (spe_program_load( data.spe_ctx, &spu)) {
		perror("Failed loading program"); exit(1);
	}		
	
	a_b[0]=1;
	a_b[1]=2;
	data.argp = (void*)a_b;
	
	printf("PPE: before: a=%d, b=%d\n",a_b[0],a_b[1] );
	
	//printf(")PPE: a_b=%llx\n", (uint64_t)data.argp );
	
	// create SPE pthreads
	if (pthread_create (&data.pthread, NULL, &spu_pthread, &data)) {
		perror("Failed creating thread");  exit(1);
	}   
		
	// wait for SPE to complete
	if (pthread_join (data.pthread, NULL)) {
		perror("Failed joining thread"); exit (1);
	}

	__lwsync();	
	printf("PPE: after: a=%d, b=%d\n",a_b[0],a_b[1] );
	
	// destroy the SPE contexts
	if (spe_context_destroy( data.spe_ctx   )) {
		perror("Failed spe_context_destroy"); exit(1);
	}

	printf("PPE: Complete with great success\n");
	
	return (0);
}

