// -------------------------------------------------------------- 
// (C)Copyright 2007,                                         
// International Business Machines Corporation, 
// All Rights Reserved.
// -------------------------------------------------------------- 

#include <stdio.h>
#include <spu_intrinsics.h>
#include <spu_mfcio.h>

unsigned int tag_base;

// Manadatory attributes
#define CACHE_NAME         MY_CACHE  // name of the cache
#define CACHED_TYPE        int		 // type of basic element in cache

// Optional attributes
#define CACHE_TYPE CACHE_TYPE_RW	// rw type of cache
#define CACHELINE_LOG2SIZE 7		// 2^7 = 128 bytes cache line
#define CACHE_LOG2NWAY     2		// 2^2 = 4-way cache
#define CACHE_LOG2NSETS    4		// 2^4 = 16 sets
#define CACHE_SET_TAGID(set) (tag_base + (set & 7)) // use 8 tag IDs
#define CACHE_STATS					//collect statistics
#include <cache-api.h>

int main(unsigned long long spu_id, unsigned long long parm)
{	
	// reserve 8 tags for the software cache	
	if((tag_base=mfc_multi_tag_reserve(8))==MFC_TAG_INVALID){
		printf( "ERROR: can't reserve a tags\n"); return 1;
	}

	// Synchronous UNSAFE mode ==================================================
	int a, b;	
	unsigned eaddr_a, eaddr_b;
	
	// initialize effective addresses from PPU parameter		
	eaddr_a = parm;
	eaddr_b = parm + sizeof(int);
		
	// read a and b from effective address
	a = cache_rd(MY_CACHE, eaddr_a);
	b = cache_rd(MY_CACHE, eaddr_b);	
	
	// write values into cache (no write-through to main memory)
	cache_wr(MY_CACHE, eaddr_b, a);
	cache_wr(MY_CACHE, eaddr_a, b);	
	
	// at this point only the variable in LS are modified

	// writes all modified (dirty) cache lines back to main memory
	cache_flush(MY_CACHE);
	
	// Asynchronous UNSAFE mode =================================================
	int *a_ptr, *b_ptr;	

	// asynchronously touch data 'b' so software cache will start to prefetch it 
	b_ptr = cache_touch(MY_CACHE, eaddr_b);
	
	// synchronously read data 'a' - blocked till data is present in LS
	a_ptr = cache_rw(MY_CACHE, eaddr_a);
		
	// MUST lock variables in LS since it will be modified. 
	// ensures that it will not cast out while the reference is held.
	cache_lock(MY_CACHE,a_ptr);

	// 'a' is locked in cache -can now safely be modified through ptr
	*a_ptr = *a_ptr+10;
	
	// blocking function that waits till 'b' is present in LS
	cache_wait(MY_CACHE, b_ptr);

	// need to lock 'b' since it will be updated
	cache_lock(MY_CACHE,b_ptr); 
	
	// now 'b' is in cache - can now safely be modified through ptr
	*b_ptr = *b_ptr+20;

	// at this point only the variable in LS are modified

	// writes all modified (dirty) cache lines back to main memory
	cache_flush(MY_CACHE);
	
	//print software cache statistics
	cache_pr_stats(MY_CACHE);
	
	mfc_multi_tag_release(tag_base, 8);
	return (0);
}
