#!/bin/sh
#
# network       Bring up/down channel-bonded networking
#
# chkconfig: 2345 1 90
# description: bond/unbond network interfaces
# probe: true

# Source function library.
. /etc/init.d/functions

CWD=`pwd`
cd /etc/sysconfig/network-scripts

if [ ! -d ENSLAVED -o ! -d SEPARATE ]; then cd $CWD ; exit 0; fi

# Check if networking is up.
if [ -f /var/lock/subsys/network -a "$1" != "status" -a "$1" != "probe" ]; then
    echo "BONDING: you need to bring the network down first! - ABORT"
    exit 1
fi

# See how we were called.
case "$1" in
  start)  
  	action "Bonding Ethernet channels: " ./bond
        touch /var/lock/subsys/bonding
        ;;
  stop)
	action "Unbonding Ethernet channels: " ./unbond
        rm -f /var/lock/subsys/network
        ;;
  status)
	echo "Bonding status:"
	ifconfig bond0
	;;
  restart)
        cd $CWD
	$0 stop
	$0 start
	;;
  reload)
	cd $CWD
	$0 restart
	;;
  probe)
	cd $CWD
	$0 status
	;;
  *)
        echo "Usage: bonding {start|stop|restart|reload|status|probe}"
        exit 1
esac
cd $CWD
exit 0
