#ifndef C_SERIAL_T_LIN_H
#define C_SERIAL_T_LIN_H

/*!
  \file
  \brief Structure of serial communication control(Linux, Mac version)

  \author Satofumi KAMIMURA

  $Id$
*/

#include <termios.h>

#ifdef __cplusplus
extern "C" {
#endif

enum {
  SerialErrorStringSize = 256,
};


/*!
  \brief structure of serial communication
*/
typedef struct {

  int errno_;
  char error_string_[SerialErrorStringSize];

  int fd_;
  struct termios sio_;           //!<terminal structure
  char last_ch_;

} serial_t;

#ifdef __cplusplus
}
#endif

#endif /*! C_SERIAL_T_LIN_H */
