#ifndef C_URG_ERRNO_H
#define C_URG_ERRNO_H

/*!
  \file
  \brief Error code of URG

  \author Satofumi KAMIMURA

  $Id$
*/

#ifdef __cplusplus
extern "C" {
#endif

enum {
  UrgNoError = 0,               /*!< Normal */
  UrgNotImplemented = -1,       /*!< Unimplemented */
  UrgSendFail = -2,
  UrgRecvFail = -3,
  UrgScip10 = -4,               /*!< Response from SCIP1.0 */
  UrgSsFail = -5,               /*!< Failure in SS command response*/
  UrgAdjustBaudrateFail = -7,   /*!< Failure in adjusting baudrate */
  UrgInvalidArgs = -8,          /*!< Invalid argument specification */

  // !!!

};


/*!
  \brief Returns error message

  \param urg_errno [i] Error return value of URG

  \return Error message
*/
extern const char* urg_strerror(int urg_errno);

#ifdef __cplusplus
}
#endif

#endif /* !C_URG_ERRNO_H */
