#ifndef URG_PARAMETER_T_H
#define URG_PARAMETER_T_H

/*!
  \file
  \brief Parameter information of URG

  \author Satofumi KAMIMURA

  $Id$
*/

#ifdef __cplusplus
extern "C" {
#endif

enum {
  UrgParameterLines = 8 + 1 + 1,
};

/*!
  \brief Parameter information of URG
*/
typedef struct {
  long distance_min_;		/*!< DMIN information */
  long distance_max_;		/*!< DMAX information */
  int area_total_;		/*!< ARES information */
  int area_min_;		/*!< AMIN information */
  int area_max_;		/*!< AMAX information */
  int area_front_;		/*!< AFRT information */
  int scan_rpm_;		/*!< SCAN information */
} urg_parameter_t;

#ifdef __cplusplus
}
#endif

#endif /* !URG_PARAMETER_T_H */
