#ifndef SERIAL_UTILS_H
#define SERIAL_UTILS_H

/*!
  \file
  \brief Auxiliary of Serial communication

  \author Satofumi KAMIMURA

  $Id$

  \todo Attach "const" keyword for input parameters
*/

#include <urg/serial_t.h>

#ifdef __cplusplus
extern "C" {
#endif

/*!
  \brief Return linefeed code

  \retval true if LF or CR
  \retval false if ch is not LF or CR
*/
extern int serial_isLF(const char ch);


/*!
  \brief Skip receiving the data 

  Vary the definition of the time of timeout to skip the receive using ConnectionInterface::clear()

  \param con [i/o] Communication resources
  \param total_timeout [i] Upper limit of timeout [msec]
  \param each_timeout [i]  Upper limit of timeout during interval of each data receive [msec]
*/
extern void serial_skip(serial_t *serial, int total_timeout,
                        int each_timeout);


/*!
  \brief Read till line feed.

  Add "\0\" at the end of string and return

  \param serial [i/o] Struct of serial control
  \param data [i] Receive data buffer
  \param data_size_max [i] Maximum size of receive buffer
  \param timeout [i] Time out [msec]

  \return Number of bytes received
*/
extern int serial_getLine(serial_t *serial,
                          char *data, int data_size_max, int timeout);

#ifdef __cplusplus
}
#endif

#endif /* !SERIAL_UTILS_H */
