#ifndef C_URG_T_H
#define C_URG_T_H

/*!
  \file
  \brief Structure of URG control

  \author Satofumi KAMIMURA

  $Id$
*/

#include <urg/urg_parameter_t.h>
#include <urg/serial_t.h>

#ifdef __cplusplus
extern "C" {
#endif

/*!
  \brief Constants used in URG structure
*/
typedef enum {
  UrgLaserOff = 0,
  UrgLaserOn,
  UrgLaserUnknown,
} urg_laser_state_t;


/*!
  \brief Structure of URG control
*/
typedef struct {

  serial_t serial_;              /*!< Structure of serial control */
  int errno_;			/*!< stores error number */
  urg_parameter_t parameters_;   /*!< Sensor parameter */

  int skip_lines_;               /*!< Number of lines to be skipped */
  int skip_frames_;              /*!< Number of scan to be skipped(MD/MS のみ) */
  int capture_times_;            /*!< Frequency at which data is capture(only for MD/MS) */

  urg_laser_state_t is_laser_on_; /*!<  0 if laser is in off state  */

  long last_timestamp_;          /*!< Last time stamp */

} urg_t;

#ifdef __cplusplus
}
#endif

#endif /* ! C_URG_T_H */
