/*
 * Decompiled with CFR 0.152.
 */
package com.primesense.nite.Samples.UserViewer;

import com.primesense.nite.JointType;
import com.primesense.nite.Point2D;
import com.primesense.nite.SkeletonJoint;
import com.primesense.nite.SkeletonState;
import com.primesense.nite.UserData;
import com.primesense.nite.UserTracker;
import com.primesense.nite.UserTrackerFrameRef;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.openni.VideoFrameRef;

public class UserViewer
extends Component
implements UserTracker.NewFrameListener {
    float[] mHistogram;
    int[] mDepthPixels;
    UserTracker mTracker;
    UserTrackerFrameRef mLastFrame;
    BufferedImage mBufferedImage;
    int[] mColors;

    public UserViewer(UserTracker userTracker) {
        this.mTracker = userTracker;
        this.mTracker.addNewFrameListener(this);
        this.mColors = new int[]{-65536, -16711936, -16776961, -256, -65281, -16711681};
    }

    @Override
    public synchronized void paint(Graphics graphics) {
        if (this.mLastFrame == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        VideoFrameRef videoFrameRef = this.mLastFrame.getDepthFrame();
        if (videoFrameRef != null) {
            int n3 = videoFrameRef.getWidth();
            int n4 = videoFrameRef.getHeight();
            if (this.mBufferedImage == null || this.mBufferedImage.getWidth() != n3 || this.mBufferedImage.getHeight() != n4) {
                this.mBufferedImage = new BufferedImage(n3, n4, 1);
            }
            this.mBufferedImage.setRGB(0, 0, n3, n4, this.mDepthPixels, 0, n3);
            n = (this.getWidth() - n3) / 2;
            n2 = (this.getHeight() - n4) / 2;
            graphics.drawImage(this.mBufferedImage, n, n2, null);
        }
        for (UserData userData : this.mLastFrame.getUsers()) {
            if (userData.getSkeleton().getState() != SkeletonState.TRACKED) continue;
            this.drawLimb(graphics, n, n2, userData, JointType.HEAD, JointType.NECK);
            this.drawLimb(graphics, n, n2, userData, JointType.LEFT_SHOULDER, JointType.LEFT_ELBOW);
            this.drawLimb(graphics, n, n2, userData, JointType.LEFT_ELBOW, JointType.LEFT_HAND);
            this.drawLimb(graphics, n, n2, userData, JointType.RIGHT_SHOULDER, JointType.RIGHT_ELBOW);
            this.drawLimb(graphics, n, n2, userData, JointType.RIGHT_ELBOW, JointType.RIGHT_HAND);
            this.drawLimb(graphics, n, n2, userData, JointType.LEFT_SHOULDER, JointType.RIGHT_SHOULDER);
            this.drawLimb(graphics, n, n2, userData, JointType.LEFT_SHOULDER, JointType.TORSO);
            this.drawLimb(graphics, n, n2, userData, JointType.RIGHT_SHOULDER, JointType.TORSO);
            this.drawLimb(graphics, n, n2, userData, JointType.LEFT_HIP, JointType.TORSO);
            this.drawLimb(graphics, n, n2, userData, JointType.RIGHT_HIP, JointType.TORSO);
            this.drawLimb(graphics, n, n2, userData, JointType.LEFT_HIP, JointType.RIGHT_HIP);
            this.drawLimb(graphics, n, n2, userData, JointType.LEFT_HIP, JointType.LEFT_KNEE);
            this.drawLimb(graphics, n, n2, userData, JointType.LEFT_KNEE, JointType.LEFT_FOOT);
            this.drawLimb(graphics, n, n2, userData, JointType.RIGHT_HIP, JointType.RIGHT_KNEE);
            this.drawLimb(graphics, n, n2, userData, JointType.RIGHT_KNEE, JointType.RIGHT_FOOT);
        }
    }

    private void drawLimb(Graphics graphics, int n, int n2, UserData userData, JointType jointType, JointType jointType2) {
        SkeletonJoint skeletonJoint = userData.getSkeleton().getJoint(jointType);
        SkeletonJoint skeletonJoint2 = userData.getSkeleton().getJoint(jointType2);
        if ((double)skeletonJoint.getPositionConfidence() == 0.0 || (double)skeletonJoint2.getPositionConfidence() == 0.0) {
            return;
        }
        Point2D<Float> point2D = this.mTracker.convertJointCoordinatesToDepth(skeletonJoint.getPosition());
        Point2D<Float> point2D2 = this.mTracker.convertJointCoordinatesToDepth(skeletonJoint2.getPosition());
        graphics.setColor(new Color(this.mColors[(userData.getId() + 1) % this.mColors.length]));
        graphics.drawLine(n + point2D.getX().intValue(), n2 + point2D.getY().intValue(), n + point2D2.getX().intValue(), n2 + point2D2.getY().intValue());
    }

    @Override
    public synchronized void onNewFrame(UserTracker userTracker) {
        if (this.mLastFrame != null) {
            this.mLastFrame.release();
            this.mLastFrame = null;
        }
        this.mLastFrame = this.mTracker.readFrame();
        for (UserData object : this.mLastFrame.getUsers()) {
            if (!object.isNew()) continue;
            this.mTracker.startSkeletonTracking(object.getId());
        }
        VideoFrameRef videoFrameRef = this.mLastFrame.getDepthFrame();
        if (videoFrameRef != null) {
            ByteBuffer byteBuffer = videoFrameRef.getData().order(ByteOrder.LITTLE_ENDIAN);
            ByteBuffer byteBuffer2 = this.mLastFrame.getUserMap().getPixels().order(ByteOrder.LITTLE_ENDIAN);
            if (this.mDepthPixels == null || this.mDepthPixels.length < videoFrameRef.getWidth() * videoFrameRef.getHeight()) {
                this.mDepthPixels = new int[videoFrameRef.getWidth() * videoFrameRef.getHeight()];
            }
            this.calcHist(byteBuffer);
            byteBuffer.rewind();
            int n = 0;
            while (byteBuffer.remaining() > 0) {
                short s = byteBuffer.getShort();
                short s2 = byteBuffer2.getShort();
                short s3 = (short)this.mHistogram[s];
                int n2 = -1;
                if (s2 > 0) {
                    n2 = this.mColors[s2 % this.mColors.length];
                }
                this.mDepthPixels[n] = n2 & (0xFF000000 | s3 << 16 | s3 << 8 | s3);
                ++n;
            }
        }
        this.repaint();
    }

    private void calcHist(ByteBuffer byteBuffer) {
        int n;
        int n2;
        if (this.mHistogram == null) {
            this.mHistogram = new float[10000];
        }
        for (n2 = 0; n2 < this.mHistogram.length; ++n2) {
            this.mHistogram[n2] = 0.0f;
        }
        n2 = 0;
        while (byteBuffer.remaining() > 0) {
            n = byteBuffer.getShort() & 0xFFFF;
            if (n == 0) continue;
            int n3 = n;
            this.mHistogram[n3] = this.mHistogram[n3] + 1.0f;
            ++n2;
        }
        for (n = 1; n < this.mHistogram.length; ++n) {
            int n4 = n;
            this.mHistogram[n4] = this.mHistogram[n4] + this.mHistogram[n - 1];
        }
        if (n2 > 0) {
            for (n = 1; n < this.mHistogram.length; ++n) {
                this.mHistogram[n] = (int)(256.0f * (1.0f - this.mHistogram[n] / (float)n2));
            }
        }
    }
}

