/*
 * Decompiled with CFR 0.152.
 */
package com.primesense.nite;

import com.primesense.nite.GestureData;
import com.primesense.nite.HandData;
import com.primesense.nite.NativeMethods;
import java.util.ArrayList;
import java.util.List;
import org.openni.VideoFrameRef;

public class HandTrackerFrameRef {
    private long mFrameHandle;
    private long mHandTrackerHandle;
    private long mTimestamp;
    private int mFrameIndex;
    private VideoFrameRef mDepthFrame;
    private List<HandData> mHands;
    private List<GestureData> mGestures;

    public long getFrameHandle() {
        return this.mFrameHandle;
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    public int getFrameIndex() {
        return this.mFrameIndex;
    }

    public List<HandData> getHands() {
        return this.mHands;
    }

    public List<GestureData> getGestures() {
        return this.mGestures;
    }

    public VideoFrameRef getDepthFrame() {
        return this.mDepthFrame;
    }

    public void release() {
        if (this.mFrameHandle != 0L) {
            NativeMethods.checkReturnStatus(NativeMethods.niteHandTrackerFrameRelease(this.mHandTrackerHandle, this.mFrameHandle));
            this.mFrameHandle = 0L;
            this.mDepthFrame.release();
            this.mDepthFrame = null;
        }
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    private HandTrackerFrameRef(long l, long l2) {
        NativeMethods.niteHandTrackerFrameAddRef(l, l2);
        this.mFrameHandle = l2;
        this.mHandTrackerHandle = l;
        this.mHands = new ArrayList<HandData>();
        this.mGestures = new ArrayList<GestureData>();
    }
}

