/*
 * Decompiled with CFR 0.152.
 */
package com.primesense.nite;

import com.primesense.nite.NativeMethods;
import com.primesense.nite.Plane;
import com.primesense.nite.UserData;
import com.primesense.nite.UserMap;
import java.util.ArrayList;
import java.util.List;
import org.openni.VideoFrameRef;

public class UserTrackerFrameRef {
    private long mFrameHandle;
    private long mUserTrackerHandle;
    private float mFloorConfidence;
    private Plane mPlane;
    private VideoFrameRef mDepthFrame;
    private UserMap mUserMap;
    private int mFrameIndex;
    private long mTimestamp;
    private List<UserData> mUserData;

    public void release() {
        if (this.mFrameHandle != 0L) {
            NativeMethods.checkReturnStatus(NativeMethods.niteUserTrackerFrameRelease(this.mUserTrackerHandle, this.mFrameHandle));
            this.mFrameHandle = 0L;
            this.mDepthFrame.release();
            this.mDepthFrame = null;
        }
    }

    public float getFloorConfidence() {
        return this.mFloorConfidence;
    }

    public Plane getPlane() {
        return this.mPlane;
    }

    public VideoFrameRef getDepthFrame() {
        return this.mDepthFrame;
    }

    public UserMap getUserMap() {
        return this.mUserMap;
    }

    public int getFrameIndex() {
        return this.mFrameIndex;
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    public List<UserData> getUsers() {
        return this.mUserData;
    }

    public UserData getUserById(short s) {
        for (UserData userData : this.mUserData) {
            if (userData.getId() != s) continue;
            return userData;
        }
        return null;
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    private UserTrackerFrameRef(long l, long l2) {
        NativeMethods.niteUserTrackerFrameAddRef(l, l2);
        this.mUserTrackerHandle = l;
        this.mFrameHandle = l2;
        this.mUserData = new ArrayList<UserData>();
    }
}

