/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import org.openni.DeviceInfo;
import org.openni.ImageRegistrationMode;
import org.openni.NativeMethods;
import org.openni.OutArg;
import org.openni.PlaybackControl;
import org.openni.SensorInfo;
import org.openni.SensorType;

public class Device {
    private long mDeviceHandle;
    private PlaybackControl mPlaybackControl;

    public static Device open(String string) {
        Device device = new Device();
        NativeMethods.checkReturnStatus(NativeMethods.oniDeviceOpen(string, device));
        if (device.isFile()) {
            device.mPlaybackControl = new PlaybackControl(device);
        }
        return device;
    }

    public static Device open() {
        Device device = new Device();
        NativeMethods.checkReturnStatus(NativeMethods.oniDeviceOpen(device));
        if (device.isFile()) {
            device.mPlaybackControl = new PlaybackControl(device);
        }
        return device;
    }

    public void close() {
        NativeMethods.checkReturnStatus(NativeMethods.oniDeviceClose(this.getHandle()));
        this.mDeviceHandle = 0L;
        this.mPlaybackControl = null;
    }

    public final DeviceInfo getDeviceInfo() {
        return NativeMethods.oniDeviceGetInfo(this.getHandle());
    }

    public boolean hasSensor(SensorType sensorType) {
        return NativeMethods.hasSensor(this.getHandle(), sensorType.toNative());
    }

    public final SensorInfo getSensorInfo(SensorType sensorType) {
        return NativeMethods.oniDeviceGetSensorInfo(this.getHandle(), sensorType.toNative());
    }

    public long getHandle() {
        return this.mDeviceHandle;
    }

    public PlaybackControl getPlaybackControl() {
        return this.mPlaybackControl;
    }

    public boolean isImageRegistrationModeSupported(ImageRegistrationMode imageRegistrationMode) {
        return NativeMethods.isImageRegistrationModeSupported(this.getHandle(), imageRegistrationMode.toNative());
    }

    public ImageRegistrationMode getImageRegistrationMode() {
        OutArg<Integer> outArg = new OutArg<Integer>();
        NativeMethods.checkReturnStatus(NativeMethods.getImageRegistrationMode(this.getHandle(), outArg));
        return ImageRegistrationMode.fromNative((Integer)outArg.mValue);
    }

    public void setImageRegistrationMode(ImageRegistrationMode imageRegistrationMode) {
        NativeMethods.checkReturnStatus(NativeMethods.setImageRegistrationMode(this.getHandle(), imageRegistrationMode.toNative()));
    }

    public boolean isFile() {
        return NativeMethods.oniDeviceIsPropertySupported(this.getHandle(), 100) && NativeMethods.oniDeviceIsPropertySupported(this.getHandle(), 101) && NativeMethods.oniDeviceIsCommandSupported(this.getHandle(), 1);
    }

    public void setDepthColorSyncEnabled(boolean bl) {
        if (bl) {
            NativeMethods.checkReturnStatus(NativeMethods.oniDeviceEnableDepthColorSync(this.getHandle()));
        } else {
            NativeMethods.oniDeviceDisableDepthColorSync(this.getHandle());
        }
    }
}

