/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import java.util.List;
import org.openni.Device;
import org.openni.DeviceInfo;
import org.openni.OutArg;
import org.openni.Recorder;
import org.openni.SensorInfo;
import org.openni.Version;
import org.openni.VideoFrameRef;
import org.openni.VideoMode;
import org.openni.VideoStream;

class NativeMethods {
    private static final int STATUS_OK = 0;
    private static final int STATUS_ERROR = 1;
    private static final int STATUS_NOT_IMPLEMENTED = 2;
    private static final int STATUS_NOT_SUPPORTED = 3;
    private static final int STATUS_BAD_PARAMETER = 4;
    private static final int STATUS_OUT_OF_FLOW = 5;
    private static final int STATUS_NO_DEVICE = 6;
    private static final int STATUS_TIME_OUT = 102;
    public static final int STREAM_PROPERTY_CROPPING = 0;
    public static final int STREAM_PROPERTY_HORIZONTAL_FOV = 1;
    public static final int STREAM_PROPERTY_VERTICAL_FOV = 2;
    public static final int STREAM_PROPERTY_MAX_VALUE = 4;
    public static final int STREAM_PROPERTY_MIN_VALUE = 5;
    public static final int STREAM_PROPERTY_STRIDE = 6;
    public static final int STREAM_PROPERTY_MIRRORING = 7;
    public static final int STREAM_PROPERTY_NUMBER_OF_FRAMES = 8;
    public static final int STREAM_PROPERTY_AUTO_EXPOSURE = 100;
    public static final int STREAM_PROPERTY_AUTO_WHITE_BALANCE = 101;
    public static final int DEVICE_PROPERTY_FIRMWARE_VERSION = 0;
    public static final int DEVICE_PROPERTY_DRIVER_VERSION = 1;
    public static final int DEVICE_PROPERTY_HARDWARE_VERSION = 2;
    public static final int DEVICE_PROPERTY_SERIAL_NUMBER = 3;
    public static final int DEVICE_PROPERTY_ERROR_STATE = 4;
    public static final int DEVICE_PROPERTY_IMAGE_REGISTRATION = 5;
    public static final int DEVICE_PROPERTY_PLAYBACK_SPEED = 100;
    public static final int DEVICE_PROPERTY_PLAYBACK_REPEAT_ENABLED = 101;
    public static final int DEVICE_COMMAND_SEEK = 1;

    NativeMethods() {
    }

    static void checkReturnStatus(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                throw new RuntimeException(NativeMethods.oniGetExtendedError());
            }
            case 2: {
                throw new UnsupportedOperationException(NativeMethods.oniGetExtendedError());
            }
            case 3: {
                throw new UnsupportedOperationException(NativeMethods.oniGetExtendedError());
            }
            case 4: {
                throw new IllegalArgumentException(NativeMethods.oniGetExtendedError());
            }
            case 5: {
                throw new IllegalStateException(NativeMethods.oniGetExtendedError());
            }
            default: {
                throw new RuntimeException(NativeMethods.oniGetExtendedError());
            }
        }
    }

    static native void oniFrameRelease(long var0);

    static native void oniFrameAddRef(long var0);

    static native int oniDeviceCreateStream(long var0, int var2, VideoStream var3);

    static native void oniStreamDestroy(long var0, long var2);

    static native int oniStreamStart(long var0);

    static native void oniStreamStop(long var0);

    static native int oniStreamReadFrame(long var0, OutArg<VideoFrameRef> var2);

    static native int getCropping(long var0, OutArg<Integer> var2, OutArg<Integer> var3, OutArg<Integer> var4, OutArg<Integer> var5);

    static native int setCropping(long var0, int var2, int var3, int var4, int var5);

    static native boolean isCroppingSupported(long var0);

    static native int resetCropping(long var0);

    static native int getVideoMode(long var0, OutArg<VideoMode> var2);

    static native int setVideoMode(long var0, int var2, int var3, int var4, int var5);

    static native SensorInfo oniStreamGetSensorInfo(long var0);

    static native boolean hasSensor(long var0, int var2);

    static native int oniStreamGetIntProperty(long var0, int var2, OutArg<Integer> var3);

    static native int oniStreamGetBoolProperty(long var0, int var2, OutArg<Boolean> var3);

    static native int oniStreamGetFloatProperty(long var0, int var2, OutArg<Float> var3);

    static native int oniStreamSetProperty(long var0, int var2, int var3);

    static native int oniStreamSetProperty(long var0, int var2, boolean var3);

    static native int oniStreamSetProperty(long var0, int var2, float var3);

    static native boolean oniStreamIsPropertySupported(long var0, int var2);

    static native SensorInfo oniDeviceGetSensorInfo(long var0, int var2);

    static native int oniDeviceEnableDepthColorSync(long var0);

    static native void oniDeviceDisableDepthColorSync(long var0);

    static native int seek(long var0, long var2, int var4);

    static native boolean isImageRegistrationModeSupported(long var0, int var2);

    static native int getImageRegistrationMode(long var0, OutArg<Integer> var2);

    static native int setImageRegistrationMode(long var0, int var2);

    static native DeviceInfo oniDeviceGetInfo(long var0);

    static native int oniRecorderStart(long var0);

    static native int oniRecorderDestroy(long var0);

    static native void oniRecorderStop(long var0);

    static native int oniRecorderAttachStream(long var0, long var2, boolean var4);

    static native int oniDeviceGetIntProperty(long var0, int var2, OutArg<Integer> var3);

    static native int oniDeviceGetBoolProperty(long var0, int var2, OutArg<Boolean> var3);

    static native int oniDeviceGetFloatProperty(long var0, int var2, OutArg<Float> var3);

    static native int oniDeviceSetProperty(long var0, int var2, int var3);

    static native int oniDeviceSetProperty(long var0, int var2, boolean var3);

    static native int oniDeviceSetProperty(long var0, int var2, float var3);

    static native boolean oniDeviceIsPropertySupported(long var0, int var2);

    static native boolean oniDeviceIsCommandSupported(long var0, int var2);

    static native int oniInitialize();

    static native void oniShutdown();

    static native Version oniGetVersion();

    static native String oniGetExtendedError();

    static native int oniGetDeviceList(List<DeviceInfo> var0);

    static native boolean oniWaitForAnyStream(long[] var0, OutArg<Integer> var1, int var2);

    static native int oniCoordinateConverterWorldToDepth(long var0, float var2, float var3, float var4, OutArg<Float> var5, OutArg<Float> var6, OutArg<Float> var7);

    static native int oniCoordinateConverterDepthToWorld(long var0, float var2, float var3, float var4, OutArg<Float> var5, OutArg<Float> var6, OutArg<Float> var7);

    static native int oniCoordinateConverterDepthToColor(long var0, long var2, int var4, int var5, short var6, OutArg<Integer> var7, OutArg<Integer> var8);

    static native int oniCreateRecorder(String var0, Recorder var1);

    static native int oniDeviceOpen(String var0, Device var1);

    static native int oniDeviceOpen(Device var0);

    static native int oniDeviceClose(long var0);

    static {
        System.loadLibrary("OpenNI2.jni");
    }
}

