/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import java.util.NoSuchElementException;

public enum PixelFormat {
    DEPTH_1_MM(100),
    DEPTH_100_UM(101),
    SHIFT_9_2(102),
    SHIFT_9_3(103),
    RGB888(200),
    YUV422(201),
    GRAY8(202),
    GRAY16(203),
    JPEG(204),
    YUYV(205);

    private final int mValue;

    private PixelFormat(int n2) {
        this.mValue = n2;
    }

    public int toNative() {
        return this.mValue;
    }

    public static PixelFormat fromNative(int n) {
        for (PixelFormat pixelFormat : PixelFormat.values()) {
            if (pixelFormat.mValue != n) continue;
            return pixelFormat;
        }
        throw new NoSuchElementException(String.format("Unknown pixel format: %d", n));
    }
}

