/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import org.openni.Device;
import org.openni.NativeMethods;
import org.openni.OutArg;
import org.openni.VideoStream;

public class PlaybackControl {
    private final Device mDevice;

    public PlaybackControl(Device device) {
        this.mDevice = device;
    }

    public float getSpeed() {
        OutArg<Float> outArg = new OutArg<Float>();
        NativeMethods.checkReturnStatus(NativeMethods.oniDeviceGetFloatProperty(this.mDevice.getHandle(), 100, outArg));
        return ((Float)outArg.mValue).floatValue();
    }

    public void setSpeed(float f) {
        NativeMethods.checkReturnStatus(NativeMethods.oniDeviceSetProperty(this.mDevice.getHandle(), 100, f));
    }

    public boolean getRepeatEnabled() {
        OutArg<Boolean> outArg = new OutArg<Boolean>();
        NativeMethods.checkReturnStatus(NativeMethods.oniDeviceGetBoolProperty(this.mDevice.getHandle(), 101, outArg));
        return (Boolean)outArg.mValue;
    }

    public void setRepeatEnabled(boolean bl) {
        NativeMethods.checkReturnStatus(NativeMethods.oniDeviceSetProperty(this.mDevice.getHandle(), 101, bl));
    }

    public void seek(VideoStream videoStream, int n) {
        NativeMethods.checkReturnStatus(NativeMethods.seek(this.mDevice.getHandle(), videoStream.getHandle(), n));
    }

    public int getNumberOfFrames(VideoStream videoStream) {
        OutArg<Integer> outArg = new OutArg<Integer>();
        NativeMethods.checkReturnStatus(NativeMethods.oniStreamGetIntProperty(videoStream.getHandle(), 8, outArg));
        return (Integer)outArg.mValue;
    }
}

