/*
 * Decompiled with CFR 0.152.
 */
package com.primesense.nite;

import com.primesense.nite.NativeMethods;
import com.primesense.nite.OutArg;
import com.primesense.nite.Point2D;
import com.primesense.nite.Point3D;
import com.primesense.nite.PoseType;
import com.primesense.nite.UserTrackerFrameRef;
import java.util.HashMap;
import java.util.Map;
import org.openni.Device;

public class UserTracker {
    private long mUserTrackerHandle;
    private long mCookieHandle;
    private static Map<UserTracker, NewFrameListener> mNewFramesListeners;

    public static UserTracker create(Device device) {
        UserTracker userTracker = new UserTracker();
        NativeMethods.checkReturnStatus(NativeMethods.niteInitializeUserTrackerByDevice(device.getHandle(), userTracker));
        return userTracker;
    }

    public static UserTracker create() {
        UserTracker userTracker = new UserTracker();
        NativeMethods.checkReturnStatus(NativeMethods.niteInitializeUserTracker(userTracker));
        return userTracker;
    }

    public void destroy() {
        NativeMethods.checkReturnStatus(NativeMethods.niteShutdownUserTracker(this.getHandle(), this.mCookieHandle));
    }

    public UserTrackerFrameRef readFrame() {
        OutArg<UserTrackerFrameRef> outArg = new OutArg<UserTrackerFrameRef>();
        NativeMethods.checkReturnStatus(NativeMethods.niteReadUserTrackerFrame(this.getHandle(), outArg));
        return (UserTrackerFrameRef)outArg.mValue;
    }

    public void setSkeletonSmoothingFactor(float f) {
        NativeMethods.checkReturnStatus(NativeMethods.niteSetSkeletonSmoothing(this.getHandle(), f));
    }

    public float getSkeletonSmoothingFactor() {
        OutArg<Float> outArg = new OutArg<Float>();
        NativeMethods.checkReturnStatus(NativeMethods.niteGetSkeletonSmoothing(this.getHandle(), outArg));
        return ((Float)outArg.mValue).floatValue();
    }

    public void startSkeletonTracking(short s) {
        NativeMethods.checkReturnStatus(NativeMethods.niteStartSkeletonTracking(this.getHandle(), s));
    }

    public void stopSkeletonTracking(short s) {
        NativeMethods.niteStopSkeletonTracking(this.getHandle(), s);
    }

    public void startPoseDetection(short s, PoseType poseType) {
        NativeMethods.checkReturnStatus(NativeMethods.niteStartPoseDetection(this.getHandle(), s, poseType.toNative()));
    }

    public void stopPoseDetection(short s, PoseType poseType) {
        NativeMethods.niteStopPoseDetection(this.getHandle(), s, poseType.toNative());
    }

    public void addNewFrameListener(NewFrameListener newFrameListener) {
        mNewFramesListeners.put(this, newFrameListener);
    }

    public void removeNewFrameListener(NewFrameListener newFrameListener) {
        for (Map.Entry<UserTracker, NewFrameListener> entry : mNewFramesListeners.entrySet()) {
            UserTracker userTracker = entry.getKey();
            if (userTracker.getHandle() != this.mUserTrackerHandle || !newFrameListener.equals(entry.getValue())) continue;
            mNewFramesListeners.remove(entry.getKey());
            return;
        }
    }

    public Point2D<Float> convertJointCoordinatesToDepth(Point3D<Float> point3D) {
        OutArg<Float> outArg = new OutArg<Float>();
        OutArg<Float> outArg2 = new OutArg<Float>();
        NativeMethods.checkReturnStatus(NativeMethods.niteConvertJointCoordinatesToDepth(this.getHandle(), point3D.getX().floatValue(), point3D.getY().floatValue(), point3D.getZ().floatValue(), outArg, outArg2));
        return new Point2D<Float>((Float)outArg.mValue, (Float)outArg2.mValue);
    }

    public Point2D<Float> convertDepthCoordinatesToJoint(Point3D<Integer> point3D) {
        OutArg<Float> outArg = new OutArg<Float>();
        OutArg<Float> outArg2 = new OutArg<Float>();
        NativeMethods.checkReturnStatus(NativeMethods.niteConvertDepthCoordinatesToJoint(this.getHandle(), point3D.getX(), point3D.getY(), point3D.getZ(), outArg, outArg2));
        return new Point2D<Float>((Float)outArg.mValue, (Float)outArg2.mValue);
    }

    public long getHandle() {
        return this.mUserTrackerHandle;
    }

    private UserTracker() {
        mNewFramesListeners = new HashMap<UserTracker, NewFrameListener>();
    }

    private static void onFrameReady(long l) {
        for (Map.Entry<UserTracker, NewFrameListener> entry : mNewFramesListeners.entrySet()) {
            UserTracker userTracker = entry.getKey();
            if (userTracker.getHandle() != l) continue;
            entry.getValue().onNewFrame(userTracker);
        }
    }

    public static interface NewFrameListener {
        public void onNewFrame(UserTracker var1);
    }
}

