/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openni.Context;
import org.openni.GeneralException;
import org.openni.NativeMethods;
import org.openni.NodeInfo;
import org.openni.ObjectWrapper;
import org.openni.ProductionNodeDescription;
import org.openni.Query;
import org.openni.StatusException;
import org.openni.WrapperUtils;

public class NodeInfoList
extends ObjectWrapper
implements Iterable<NodeInfo> {
    private boolean own;

    NodeInfoList(long l, boolean bl) {
        super(l);
        this.own = bl;
    }

    NodeInfoList(long l) {
        super(l);
        this.own = true;
    }

    public void add(ProductionNodeDescription productionNodeDescription, String string, NodeInfoList nodeInfoList) throws StatusException {
        long l = productionNodeDescription.createNative();
        int n = NativeMethods.xnNodeInfoListAdd(this.toNative(), l, string, nodeInfoList == null ? 0L : nodeInfoList.toNative());
        ProductionNodeDescription.freeNative(l);
        WrapperUtils.throwOnError(n);
    }

    public void addNode(NodeInfo nodeInfo) throws StatusException {
        int n = NativeMethods.xnNodeInfoListAddNode(this.toNative(), nodeInfo.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void addNodeFromList(Iterator<NodeInfo> iterator) throws StatusException {
        NodeInfoListIterator nodeInfoListIterator = (NodeInfoListIterator)iterator;
        int n = NativeMethods.xnNodeInfoListAddNodeFromList(this.toNative(), nodeInfoListIterator.it);
        WrapperUtils.throwOnError(n);
    }

    public void remove(Iterator<NodeInfo> iterator) throws StatusException {
        NodeInfoListIterator nodeInfoListIterator = (NodeInfoListIterator)iterator;
        int n = NativeMethods.xnNodeInfoListRemove(this.toNative(), nodeInfoListIterator.it);
        WrapperUtils.throwOnError(n);
    }

    public void clear() throws StatusException {
        int n = NativeMethods.xnNodeInfoListClear(this.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void append(NodeInfoList nodeInfoList) throws StatusException {
        int n = NativeMethods.xnNodeInfoListAppend(this.toNative(), nodeInfoList.toNative());
        WrapperUtils.throwOnError(n);
    }

    public boolean isEmpty() {
        return NativeMethods.xnNodeInfoListIsEmpty(this.toNative());
    }

    public void filter(Query query, Context context) throws StatusException {
        int n = NativeMethods.xnNodeQueryFilterList(context.toNative(), query.toNative(), this.toNative());
        WrapperUtils.throwOnError(n);
    }

    @Override
    public Iterator<NodeInfo> iterator() {
        return new NodeInfoListIterator(this.toNative());
    }

    @Override
    protected void freeObject(long l) {
        if (this.own) {
            NativeMethods.xnNodeInfoListFree(l);
        }
    }

    private class NodeInfoListIterator
    implements Iterator<NodeInfo> {
        protected long it;

        NodeInfoListIterator(long l) {
            this.it = NativeMethods.xnNodeInfoListGetFirst(l);
        }

        @Override
        public boolean hasNext() {
            return NativeMethods.xnNodeInfoListIteratorIsValid(this.it);
        }

        @Override
        public NodeInfo next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            NodeInfo nodeInfo = null;
            try {
                nodeInfo = new NodeInfo(NativeMethods.xnNodeInfoListGetCurrent(this.it));
            }
            catch (GeneralException generalException) {
                // empty catch block
            }
            this.it = NativeMethods.xnNodeInfoListGetNext(this.it);
            return nodeInfo;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

