/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import org.openni.Capability;
import org.openni.CapabilityBase;
import org.openni.IStateChangedObservable;
import org.openni.NativeMethods;
import org.openni.OutArg;
import org.openni.ProductionNode;
import org.openni.StateChangedObservable;
import org.openni.StatusException;
import org.openni.WrapperUtils;

public class GeneralIntCapability
extends CapabilityBase {
    private StateChangedObservable valueChanged;
    private final String capName;
    private int min;
    private int max;
    private int step;
    private int defaultVal;
    private boolean autoSupported;

    public GeneralIntCapability(ProductionNode productionNode, Capability capability) throws StatusException {
        super(productionNode);
        this.capName = capability.getName();
        OutArg<Integer> outArg = new OutArg<Integer>();
        OutArg<Integer> outArg2 = new OutArg<Integer>();
        OutArg<Integer> outArg3 = new OutArg<Integer>();
        OutArg<Integer> outArg4 = new OutArg<Integer>();
        OutArg<Boolean> outArg5 = new OutArg<Boolean>();
        int n = NativeMethods.xnGetGeneralIntRange(this.toNative(), this.getCapName(), outArg, outArg2, outArg3, outArg4, outArg5);
        WrapperUtils.throwOnError(n);
        this.min = (Integer)outArg.value;
        this.max = (Integer)outArg2.value;
        this.step = (Integer)outArg3.value;
        this.defaultVal = (Integer)outArg4.value;
        this.autoSupported = (Boolean)outArg5.value;
        this.valueChanged = new StateChangedObservable(){

            @Override
            protected int registerNative(String string, OutArg<Long> outArg) {
                return NativeMethods.xnRegisterToGeneralIntValueChange(GeneralIntCapability.this.toNative(), GeneralIntCapability.this.getCapName(), this, string, outArg);
            }

            @Override
            protected void unregisterNative(long l) {
                NativeMethods.xnUnregisterFromNodeErrorStateChange(GeneralIntCapability.this.toNative(), l);
            }
        };
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getStep() {
        return this.step;
    }

    public int getDefault() {
        return this.defaultVal;
    }

    public boolean isAutoSupported() {
        return this.autoSupported;
    }

    public int getValue() throws StatusException {
        OutArg<Integer> outArg = new OutArg<Integer>();
        int n = NativeMethods.xnGetGeneralIntValue(this.toNative(), this.capName, outArg);
        WrapperUtils.throwOnError(n);
        return (Integer)outArg.value;
    }

    public void setValue(int n) throws StatusException {
        int n2 = NativeMethods.xnSetGeneralIntValue(this.toNative(), this.capName, n);
        WrapperUtils.throwOnError(n2);
    }

    public IStateChangedObservable getValueChangedEvent() {
        return this.valueChanged;
    }

    String getCapName() {
        return this.capName;
    }
}

