/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import org.openni.CapabilityBase;
import org.openni.IObservable;
import org.openni.NativeMethods;
import org.openni.Observable;
import org.openni.OutArg;
import org.openni.PoseDetectionEventArgs;
import org.openni.PoseDetectionInProgressEventArgs;
import org.openni.PoseDetectionState;
import org.openni.PoseDetectionStatus;
import org.openni.ProductionNode;
import org.openni.StatusException;
import org.openni.WrapperUtils;

public class PoseDetectionCapability
extends CapabilityBase {
    private Observable<PoseDetectionEventArgs> poseDetectedEvent = new Observable<PoseDetectionEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> outArg) throws StatusException {
            return NativeMethods.xnRegisterToPoseDetected(PoseDetectionCapability.this.toNative(), this, "callback", outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromPoseDetected(PoseDetectionCapability.this.toNative(), l);
        }

        public void callback(String string, int n) {
            this.notify(new PoseDetectionEventArgs(string, n));
        }
    };
    private Observable<PoseDetectionEventArgs> outOfPoseEvent = new Observable<PoseDetectionEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> outArg) throws StatusException {
            return NativeMethods.xnRegisterToOutOfPose(PoseDetectionCapability.this.toNative(), this, "callback", outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromOutOfPose(PoseDetectionCapability.this.toNative(), l);
        }

        public void callback(String string, int n) {
            this.notify(new PoseDetectionEventArgs(string, n));
        }
    };
    private Observable<PoseDetectionInProgressEventArgs> poseDetectionInProgressEvent = new Observable<PoseDetectionInProgressEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> outArg) throws StatusException {
            return NativeMethods.xnRegisterToPoseDetectionInProgress(PoseDetectionCapability.this.toNative(), this, "callback", outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromPoseDetectionInProgress(PoseDetectionCapability.this.toNative(), l);
        }

        public void callback(String string, int n, int n2) {
            this.notify(new PoseDetectionInProgressEventArgs(string, n, PoseDetectionStatus.fromNative(n2)));
        }
    };

    public PoseDetectionCapability(ProductionNode productionNode) throws StatusException {
        super(productionNode);
    }

    public int getNumberOfPoses() {
        return NativeMethods.xnGetNumberOfPoses(this.toNative());
    }

    public boolean isPoseSupported(String string) {
        return NativeMethods.xnIsPoseSupported(this.toNative(), string);
    }

    public void getPoseStatus(int n, String string, OutArg<Long> outArg, OutArg<PoseDetectionStatus> outArg2, OutArg<PoseDetectionState> outArg3) throws StatusException {
        OutArg<Integer> outArg4 = new OutArg<Integer>();
        OutArg<Integer> outArg5 = new OutArg<Integer>();
        int n2 = NativeMethods.xnGetPoseStatus(this.toNative(), n, string, outArg, outArg4, outArg5);
        outArg2.value = PoseDetectionStatus.fromNative((Integer)outArg4.value);
        outArg3.value = PoseDetectionState.fromNative((Integer)outArg5.value);
        WrapperUtils.throwOnError(n2);
    }

    public String[] getAllAvailablePoses() throws StatusException {
        OutArg<String[]> outArg = new OutArg<String[]>();
        int n = NativeMethods.xnGetAllAvailablePoses(this.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        return (String[])outArg.value;
    }

    @Deprecated
    public void StartPoseDetection(String string, int n) throws StatusException {
        int n2 = NativeMethods.xnStartPoseDetection(this.toNative(), string, n);
        WrapperUtils.throwOnError(n2);
    }

    @Deprecated
    public void StopPoseDetection(int n) throws StatusException {
        int n2 = NativeMethods.xnStopPoseDetection(this.toNative(), n);
        WrapperUtils.throwOnError(n2);
    }

    public void startPoseDetection(String string, int n) throws StatusException {
        int n2 = NativeMethods.xnStartPoseDetection(this.toNative(), string, n);
        WrapperUtils.throwOnError(n2);
    }

    public void stopPoseDetection(int n) throws StatusException {
        int n2 = NativeMethods.xnStopPoseDetection(this.toNative(), n);
        WrapperUtils.throwOnError(n2);
    }

    public void stopSinglePoseDetection(int n, String string) throws StatusException {
        int n2 = NativeMethods.xnStopSinglePoseDetection(this.toNative(), n, string);
        WrapperUtils.throwOnError(n2);
    }

    public IObservable<PoseDetectionEventArgs> getPoseDetectedEvent() {
        return this.poseDetectedEvent;
    }

    public IObservable<PoseDetectionEventArgs> getOutOfPoseEvent() {
        return this.outOfPoseEvent;
    }

    public IObservable<PoseDetectionInProgressEventArgs> getPoseDetectionInProgressEvent() {
        return this.poseDetectionInProgressEvent;
    }
}

