/*
 * Decompiled with CFR 0.152.
 */
package com.primesense.NITE;

import com.primesense.NITE.IMessageGenerator;
import com.primesense.NITE.MessageGenerator;
import com.primesense.NITE.MessageListener;
import com.primesense.NITE.NativeMethods;
import com.primesense.NITE.PointControl;
import org.OpenNI.GeneralException;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class PointFilter
extends PointControl
implements IMessageGenerator {
    private MessageGenerator generator;
    private boolean localFilter;

    public PointFilter() throws GeneralException {
        this("PointFilter");
    }

    public PointFilter(String string) throws GeneralException {
        super(NativeMethods.xnvPointFilter_Create(string));
        this.init(true);
    }

    public PointFilter(long l) throws GeneralException {
        super(l);
        this.init(false);
    }

    private void init(boolean bl) throws GeneralException {
        this.localFilter = bl;
        this.generator = new MessageGenerator(this.toNative());
    }

    @Override
    protected void freeObject() {
        super.freeObject();
        this.generator.dispose();
        if (this.localFilter) {
            NativeMethods.xnvPointFilter_Destroy(this.toNative());
        }
        this.localFilter = false;
    }

    public void overridePrimary(int n) throws StatusException {
        int n2 = NativeMethods.xnvPointFilter_OverridePrimary(this.toNative(), n);
        WrapperUtils.throwOnError((int)n2);
    }

    @Override
    public void addListener(MessageListener messageListener) throws StatusException {
        this.generator.addListener(messageListener);
    }

    @Override
    public void removeListener(MessageListener messageListener) throws StatusException {
        this.generator.removeListener(messageListener);
    }

    @Override
    public void generate(long l) throws StatusException {
        this.generator.generate(l);
    }
}

