/***********************************************************
*  --- OpenSURF ---                                        *
*  This library is distributed under the GNU GPL. Please   *
*  contact chris.evans@irisys.co.uk for more information.  *
*                                                          *
*  C. Evans, Research Into Robust Visual Features,         *
*  MSc University of Bristol, 2008.                        *
*                                                          *
************************************************************/

/**
   NOTE: This is a hacked version of Chris Evans's OpenSURF library. It
   was hacked by Manu Viswanathan for use at USC's iLab. Please do not
   bother Chris Evans with problems in this hacked version.

   Some of the changes from the original OpenSURF code base include:
      - file name changes
      - wrapping of all classes and functions in a namespace
      - autotools build system and "librarification" for GNU/Linux
      - class/function name changes
      - minor changes to class/function semantics and external API
      - code clean-up to eliminate compiler warnings
      - etc.

   The actual guts of the implementation/internals performing the SURF
   computations remains the same.

   Nonetheless, do not trust this code to actually do what it purports to
   do. Neither Manu Viswanathan nor iLab assume any responsibility or
   liability of any sort whatsoever.
*/

#ifndef OPENSURF_IPOINT_DOT_HH
#define OPENSURF_IPOINT_DOT_HH

//------------------------------ HEADERS --------------------------------

// Standard C++ headers
#include <vector>
#include <utility>

//----------------------- FORWARD DECLARATIONS --------------------------

// This should be available from the OpenCV headers
struct CvPoint ;

//----------------------------- NAMESPACE -------------------------------

/**
   \namespace opensurf
   \brief Namespace encapsulating the OpenSURF library.

   All the OpenSURF classes, functions and other definitions are wrapped
   inside of the opensurf namespace.

   \remark This namespace encapsulation is specific to Manu Viswanathan's
   hacked version of the OpenSURF library and is not part of the
   original.
*/
namespace opensurf {

//------------------------- CLASS DEFINITION ----------------------------

class IPoint {
public:
   /// Coordinates of the detected interest point.
   float x, y ;

   /// Detected scale.
   float scale ;

   /// Orientation measured anti-clockwise from +ve x-axis.
   float orientation ;

   /// Sign of laplacian for fast matching purposes.
   int laplacian ;

   /// Vector of descriptor components.
   float descriptor[64] ;

   /// Placeholders for point motion (can be used for frame-to-frame
   /// motion analysis).
   float dx, dy ;

   /// Used to store cluster index.
   int clusterIndex ;

   /// Initialization
   IPoint() ;

   /// Clean-up.
   ~IPoint() ;

   /// Get the distance in descriptor space between IPoints.
   float operator-(const IPoint &rhs) const ;
} ;

//---------------------- INTEREST POINT MATCHING ------------------------

/// A pair of matching interest points.
typedef std::pair<IPoint, IPoint> MatchingIPoints ;

/// Find matches between two lists of IPoints.
std::vector<MatchingIPoints>
findMatches(std::vector<IPoint>& P1, std::vector<IPoint>& P2) ;

/// Find homography between matched points and translate src_corners to
/// dst_corners
int translateCorners(std::vector<MatchingIPoints>& matches,
                     const CvPoint src_corners[4], CvPoint dst_corners[4]);

//-----------------------------------------------------------------------

} // end of namespace encapsulating this file

#endif
