/***********************************************************
*  --- OpenSURF ---                                        *
*  This library is distributed under the GNU GPL. Please   *
*  contact chris.evans@irisys.co.uk for more information.  *
*                                                          *
*  C. Evans, Research Into Robust Visual Features,         *
*  MSc University of Bristol, 2008.                        *
*                                                          *
************************************************************/

/**
   NOTE: This is a hacked version of Chris Evans's OpenSURF library. It
   was hacked by Manu Viswanathan for use at USC's iLab. Please do not
   bother Chris Evans with problems in this hacked version.

   Some of the changes from the original OpenSURF code base include:
      - file name changes
      - wrapping of all classes and functions in a namespace
      - autotools build system and "librarification" for GNU/Linux
      - class/function name changes
      - minor changes to class/function semantics and external API
      - code clean-up to eliminate compiler warnings
      - etc.

   The actual guts of the implementation/internals performing the SURF
   computations remains the same.

   Nonetheless, do not trust this code to actually do what it purports to
   do. Neither Manu Viswanathan nor iLab assume any responsibility or
   liability of any sort whatsoever.
*/

#ifndef OPENSURF_INTEGRAL_DOT_HH
#define OPENSURF_INTEGRAL_DOT_HH

//----------------------- FORWARD DECLARATIONS --------------------------

// This should be available from the OpenCV headers
typedef struct _IplImage IplImage ;

//----------------------------- NAMESPACE -------------------------------

/**
   \namespace opensurf
   \brief Namespace encapsulating the OpenSURF library.

   All the OpenSURF classes, functions and other definitions are wrapped
   inside of the opensurf namespace.

   \remark This namespace encapsulation is specific to Manu Viswanathan's
   hacked version of the OpenSURF library and is not part of the
   original.
*/
namespace opensurf {

//-------------------------------- API ----------------------------------

/// Computes the integral image of image img. Assumes source image to be
/// a 32-bit floating point. Returns IplImage in 32-bit float form.
IplImage* Integral(IplImage* img) ;

/// Computes the sum of pixels within the rectangle specified by the
/// top-left start co-ordinate and size.
float BoxIntegral(IplImage* img, int row, int col, int rows, int cols) ;

//-----------------------------------------------------------------------

} // end of namespace encapsulating this file

#endif
