/***********************************************************
*  --- OpenSURF ---                                        *
*  This library is distributed under the GNU GPL. Please   *
*  contact chris.evans@irisys.co.uk for more information.  *
*                                                          *
*  C. Evans, Research Into Robust Visual Features,         *
*  MSc University of Bristol, 2008.                        *
*                                                          *
************************************************************/

/**
   NOTE: This is a hacked version of Chris Evans's OpenSURF library. It
   was hacked by Manu Viswanathan for use at USC's iLab. Please do not
   bother Chris Evans with problems in this hacked version.

   Some of the changes from the original OpenSURF code base include:
      - file name changes
      - wrapping of all classes and functions in a namespace
      - autotools build system and "librarification" for GNU/Linux
      - class/function name changes
      - minor changes to class/function semantics and external API
      - code clean-up to eliminate compiler warnings
      - etc.

   The actual guts of the implementation/internals performing the SURF
   computations remains the same.

   Nonetheless, do not trust this code to actually do what it purports to
   do. Neither Manu Viswanathan nor iLab assume any responsibility or
   liability of any sort whatsoever.
*/

#ifndef OPENSURF_DEFAULTS_DOT_HH
#define OPENSURF_DEFAULTS_DOT_HH

//----------------------------- NAMESPACE -------------------------------

/**
   \namespace opensurf
   \brief Namespace encapsulating the OpenSURF library.

   All the OpenSURF classes, functions and other definitions are wrapped
   inside of the opensurf namespace.

   \remark This namespace encapsulation is specific to Manu Viswanathan's
   hacked version of the OpenSURF library and is not part of the
   original.
*/
namespace opensurf {

//----------------------------- CONSTANTS -------------------------------

/// The default number of octaves to calculate when running the SURF
/// algorithm.
static const int DEFAULT_NUM_OCTAVES = 4 ;

/// The default number of intervals per octave.
static const int DEFAULT_NUM_INTERVALS = 4 ;

/// The default initial sampling step.
static const int DEFAULT_INITIAL_SAMPLING_STEP = 2 ;

/// The default blob response threshold.
static const float DEFAULT_BLOB_RESPONSE_THRESHOLD = 0.0004f ;

//-----------------------------------------------------------------------

} // end of namespace encapsulating this file

#endif
