#ifndef C_SERIAL_CTRL_H
#define C_SERIAL_CTRL_H

/*!
  \file
  \brief Serial Communication

  Serial Communication Interface management

  \author Satofumi KAMIMURA

  $Id$
*/

#include <urg/serial_t.h>

#ifdef __cplusplus
extern "C" {
#endif

/*!
  \brief Connection

  \param serial [i/o] Struct of serial control
  \param device [i] Connection device
  \param baudrate [i] Connection baudrate

  \retval 0 Success
  \retval < 0 Error
*/
extern int serial_connect(serial_t *serial, const char *device, long baudrate);


/*!
  \brief Disconnect

  \param serial [i/o] Struct of serial control
*/
extern void serial_disconnect(serial_t *serial);


/*!
  \brief Return the status of connection

  \param serial [i/o] Struct of serial control

  \retval 1 Connected state
  \retval 0 Disconnected state
*/
extern int serial_isConnected(serial_t *serial);


extern int serial_setBaudrate(serial_t *serial, long baudrate);


/*!
  \brief Sending

  \param serial [i/o] Struct of serial control
  \param data [i] Data to be send
  \param data_size [i] Size of data to be send

  \retval >= 0 Size of sent data
  \retval < 0 Error
*/
extern int serial_send(serial_t *serial, const char *data, int data_size);


/*!
  \brief Receive

  \param serial [i/o] Struct of serial control
  \param data [i]  Receive data storage buffer.
  \param data_size_max [i] Maximum size of receice buffer
  \param timeout [i] TimeOut [msec]

  \retval >= 0 Received data size
  \retval < 0 Error
*/
extern int serial_recv(serial_t *serial,
                       char *data, int data_size_max, int timeout);


/*!
  \brief Return one received character

  \param serial [i/o] Struct of serial control
  \param ch [i] A character to be written back

  \attention Don`t continuosly write back the character without reading it.
*/
extern void serial_ungetc(serial_t *serial, char ch);

#ifdef __cplusplus
}
#endif

#endif /* !C_SERIAL_CTRL_H */
