/*!
  \file
  \brief Auxiliary of Serial communication

  \author Satofumi KAMIMURA

  $Id$
*/

#include <urg/serial_utils.h>
#include <urg/serial_ctrl.h>


/* Deciding the LineFeed. */
int serial_isLF(const char ch) {

  return ((ch == '\r') || (ch == '\n')) ? 1 : 0;
}


/* Skip receiving the data */
void serial_skip(serial_t *serial, int total_timeout, int each_timeout) {

  char recv_ch;

  /* clear the last character that is put back to queue */
  serial->last_ch_ = '\0';

  if (each_timeout <= 0) {
    each_timeout = total_timeout;
  }

  while (1) {
    int n = serial_recv(serial, &recv_ch, 1, each_timeout);
    if (n <= 0) {
      break;
    }
  }
}


/* Read upto linefeed */
int serial_getLine(serial_t *serial, char* data, int data_size_max,
                   int timeout) {

  /*   Evaluate after reading each character*/
  int filled = 0;
  while (filled < data_size_max) {
    char recv_ch;
    int n = serial_recv(serial, &recv_ch, 1, timeout);
    if ((n <= 0) || serial_isLF(recv_ch)) {
      break;
    }
    data[filled++] = recv_ch;
  }
  if (filled == data_size_max) {
    --filled;
    serial_ungetc(serial, data[filled]);
  }
  data[filled] = '\0';

  /* fprintf(stderr, "#%s#\n", data); */

  return filled;
}
