/*!
  \file
  \brief Error code of URG

  \author Satofumi KAMIMURA

  $Id$
*/

#include <urg/urg_errno.h>

#include <stdio.h>


/* Returns error message */
const char* urg_strerror(int errno) {

  /* !!! Prone for errors if any addition or changes are made. Must be modified */

  const char *errorStr[] = {
    "No Error.",
    "Not Implemented.",
    "Send fail.",
    "Receive fail.",

    /* !!! */
  };

  if (errno > 0) {
    /*  Treat as normal ,if response is not an error */
    errno = 0;
  }

  return errorStr[-errno];
}
