/*
 * Decompiled with CFR 0.152.
 */
package com.primesense.NITE;

import com.primesense.NITE.NativeMethods;
import com.primesense.NITE.PointControl;
import com.primesense.NITE.ValueEventArgs;
import com.primesense.NITE.VelocityAngleEventArgs;
import org.OpenNI.GeneralException;
import org.OpenNI.IObservable;
import org.OpenNI.Observable;
import org.OpenNI.OutArg;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class PushDetector
extends PointControl {
    private Observable<VelocityAngleEventArgs> pushEvent = new Observable<VelocityAngleEventArgs>(){

        protected int registerNative(OutArg<Long> outArg) {
            return NativeMethods.xnvPushDetector_RegisterPush(PushDetector.this.toNative(), (Object)this, "callback", outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnvPushDetector_UnregisterPush(PushDetector.this.toNative(), l);
        }

        public void callback(float f, float f2) {
            this.notify((Object)new VelocityAngleEventArgs(f, f2));
        }
    };
    private Observable<ValueEventArgs> stabilizedEvent = new Observable<ValueEventArgs>(){

        protected int registerNative(OutArg<Long> outArg) {
            return NativeMethods.xnvPushDetector_RegisterStabilized(PushDetector.this.toNative(), (Object)this, "callback", outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnvPushDetector_UnregisterStabilized(PushDetector.this.toNative(), l);
        }

        public void callback(float f) {
            this.notify((Object)new ValueEventArgs(f));
        }
    };

    public PushDetector(String string) throws GeneralException {
        super(NativeMethods.xnvPushDetector_Create(string));
    }

    public PushDetector() throws GeneralException {
        this("PushDetector");
    }

    @Override
    protected void freeObject() {
        super.freeObject();
        NativeMethods.xnvPushDetector_Destroy(this.toNative());
    }

    public void reset() throws StatusException {
        int n = NativeMethods.xnvPushDetector_Reset(this.toNative());
        WrapperUtils.throwOnError((int)n);
    }

    public void setPushImmediateMinimumVelocity(float f) throws StatusException {
        int n = NativeMethods.xnvPushDetector_SetPushImmediateMinimumVelocity(this.toNative(), f);
        WrapperUtils.throwOnError((int)n);
    }

    public float getPushImmediateMinimumVelocity() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvPushDetector_GetPushImmediateMinimumVelocity(this.toNative(), (OutArg<Float>)outArg);
        WrapperUtils.throwOnError((int)n);
        return ((Float)outArg.value).floatValue();
    }

    public void setPushImmediateDuration(int n) throws StatusException {
        int n2 = NativeMethods.xnvPushDetector_SetPushImmediateDuration(this.toNative(), n);
        WrapperUtils.throwOnError((int)n2);
    }

    public int getPushImmediateDuration() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvPushDetector_GetPushImmediateDuration(this.toNative(), (OutArg<Integer>)outArg);
        WrapperUtils.throwOnError((int)n);
        return (Integer)outArg.value;
    }

    public void setPushImmediateOffset(int n) throws StatusException {
        int n2 = NativeMethods.xnvPushDetector_SetPushImmediateOffset(this.toNative(), n);
        WrapperUtils.throwOnError((int)n2);
    }

    public int getPushImmediateOffset() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvPushDetector_GetPushImmediateOffset(this.toNative(), (OutArg<Integer>)outArg);
        WrapperUtils.throwOnError((int)n);
        return (Integer)outArg.value;
    }

    public void setPushPreviousMinimumVelocity(float f) throws StatusException {
        int n = NativeMethods.xnvPushDetector_SetPushPreviousMinimumVelocity(this.toNative(), f);
        WrapperUtils.throwOnError((int)n);
    }

    public float getPushPreviousMinimumVelocity() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvPushDetector_GetPushPreviousMinimumVelocity(this.toNative(), (OutArg<Float>)outArg);
        WrapperUtils.throwOnError((int)n);
        return ((Float)outArg.value).floatValue();
    }

    public void setPushPreviousDuration(int n) throws StatusException {
        int n2 = NativeMethods.xnvPushDetector_SetPushPreviousDuration(this.toNative(), n);
        WrapperUtils.throwOnError((int)n2);
    }

    public int getPushPreviousDuration() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvPushDetector_GetPushPreviousDuration(this.toNative(), (OutArg<Integer>)outArg);
        WrapperUtils.throwOnError((int)n);
        return (Integer)outArg.value;
    }

    public void setPushPreviousOffset(int n) throws StatusException {
        int n2 = NativeMethods.xnvPushDetector_SetPushPreviousOffset(this.toNative(), n);
        WrapperUtils.throwOnError((int)n2);
    }

    public int getPushPreviousOffset() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvPushDetector_GetPushPreviousOffset(this.toNative(), (OutArg<Integer>)outArg);
        WrapperUtils.throwOnError((int)n);
        return (Integer)outArg.value;
    }

    public void setPushMaximumAngleBetweenImmediateAndZ(float f) throws StatusException {
        int n = NativeMethods.xnvPushDetector_SetPushMaximumAngleBetweenImmediateAndZ(this.toNative(), f);
        WrapperUtils.throwOnError((int)n);
    }

    public float getPushMaximumAngleBetweenImmediateAndZ() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvPushDetector_GetPushMaximumAngleBetweenImmediateAndZ(this.toNative(), (OutArg<Float>)outArg);
        WrapperUtils.throwOnError((int)n);
        return ((Float)outArg.value).floatValue();
    }

    public void setPushMinimumAngleBetweenImmediateAndPrevious(float f) throws StatusException {
        int n = NativeMethods.xnvPushDetector_SetPushMinimumAngleBetweenImmediateAndPrevious(this.toNative(), f);
        WrapperUtils.throwOnError((int)n);
    }

    public float getPushMinimumAngleBetweenImmediateAndPrevious() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvPushDetector_GetPushMinimumAngleBetweenImmediateAndPrevious(this.toNative(), (OutArg<Float>)outArg);
        WrapperUtils.throwOnError((int)n);
        return ((Float)outArg.value).floatValue();
    }

    public void setStableMaximumVelocity(float f) throws StatusException {
        int n = NativeMethods.xnvPushDetector_SetStableMaximumVelocity(this.toNative(), f);
        WrapperUtils.throwOnError((int)n);
    }

    public float getStableMaximumVelocity() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvPushDetector_GetStableMaximumVelocity(this.toNative(), (OutArg<Float>)outArg);
        WrapperUtils.throwOnError((int)n);
        return ((Float)outArg.value).floatValue();
    }

    public void setStableDuration(int n) throws StatusException {
        int n2 = NativeMethods.xnvPushDetector_SetStableDuration(this.toNative(), n);
        WrapperUtils.throwOnError((int)n2);
    }

    public int getStableDuration() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvPushDetector_GetStableDuration(this.toNative(), (OutArg<Integer>)outArg);
        WrapperUtils.throwOnError((int)n);
        return (Integer)outArg.value;
    }

    public IObservable<VelocityAngleEventArgs> getPushEvent() {
        return this.pushEvent;
    }

    public IObservable<ValueEventArgs> getStabilizedEvent() {
        return this.stabilizedEvent;
    }
}

